/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.invertedindex;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.creator.impl.inv.text.LuceneFSTIndexCreator;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneFSTIndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneFSTIndexHandler.class);
    private final File _indexDir;
    private final SegmentDirectory.Writer _segmentWriter;
    private final String _segmentName;
    private final SegmentVersion _segmentVersion;
    private final Set<ColumnMetadata> _fstIndexColumns = new HashSet<ColumnMetadata>();

    public LuceneFSTIndexHandler(File indexDir, SegmentMetadata segmentMetadata, Set<String> fstIndexColumns, SegmentDirectory.Writer segmentWriter) {
        this._indexDir = indexDir;
        this._segmentWriter = segmentWriter;
        this._segmentName = segmentMetadata.getName();
        this._segmentVersion = segmentMetadata.getVersion();
        for (String column : fstIndexColumns) {
            ColumnMetadata columnMetadata = segmentMetadata.getColumnMetadataFor(column);
            if (columnMetadata == null) continue;
            this._fstIndexColumns.add(columnMetadata);
        }
    }

    private void checkUnsupportedOperationsForFSTIndex(ColumnMetadata columnMetadata) {
        String column = columnMetadata.getColumnName();
        if (columnMetadata.getDataType() != FieldSpec.DataType.STRING) {
            throw new UnsupportedOperationException("FST index is currently only supported on STRING columns: " + column);
        }
        if (!columnMetadata.hasDictionary()) {
            throw new UnsupportedOperationException("FST index is currently only supported on dictionary encoded columns: " + column);
        }
        if (!columnMetadata.isSingleValue()) {
            throw new UnsupportedOperationException("FST index is currently not supported on multi-value columns: " + column);
        }
    }

    public void createFSTIndexesOnSegmentLoad() throws Exception {
        for (ColumnMetadata columnMetadata : this._fstIndexColumns) {
            this.checkUnsupportedOperationsForFSTIndex(columnMetadata);
            this.createFSTIndexForColumn(columnMetadata);
        }
    }

    private void createFSTIndexForColumn(ColumnMetadata columnMetadata) throws IOException {
        String column = columnMetadata.getColumnName();
        File inProgress = new File(this._indexDir, column + ".fst.inprogress");
        File fstIndexFile = new File(this._indexDir, column + ".lucene.fst");
        if (!inProgress.exists()) {
            if (this._segmentWriter.hasIndexFor(column, ColumnIndexType.FST_INDEX)) {
                LOGGER.info("Found fst index for column: {}, in segment: {}", (Object)column, (Object)this._segmentName);
                return;
            }
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)fstIndexFile);
        }
        LOGGER.info("Creating new FST index for column: {} in segment: {}, cardinality: {}", new Object[]{column, this._segmentName, columnMetadata.getCardinality()});
        LuceneFSTIndexCreator luceneFSTIndexCreator = new LuceneFSTIndexCreator(this._indexDir, column, null);
        try (BaseImmutableDictionary dictionary = LoaderUtils.getDictionary((SegmentDirectory.Reader)this._segmentWriter, columnMetadata);){
            for (int dictId = 0; dictId < dictionary.length(); ++dictId) {
                luceneFSTIndexCreator.add(dictionary.getStringValue(dictId));
            }
        }
        luceneFSTIndexCreator.seal();
        if (this._segmentVersion == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(this._segmentWriter, column, fstIndexFile, ColumnIndexType.FST_INDEX);
        }
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created FST index for segment: {}, column: {}", (Object)this._segmentName, (Object)column);
    }
}

