/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.invertedindex;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.creator.impl.inv.RangeIndexCreator;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeIndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RangeIndexHandler.class);
    private final File _indexDir;
    private final SegmentDirectory.Writer _segmentWriter;
    private final String _segmentName;
    private final SegmentVersion _segmentVersion;
    private final Set<ColumnMetadata> _rangeIndexColumns = new HashSet<ColumnMetadata>();

    public RangeIndexHandler(File indexDir, SegmentMetadata segmentMetadata, IndexLoadingConfig indexLoadingConfig, SegmentDirectory.Writer segmentWriter) {
        this._indexDir = indexDir;
        this._segmentWriter = segmentWriter;
        this._segmentName = segmentMetadata.getName();
        this._segmentVersion = segmentMetadata.getVersion();
        for (String column : indexLoadingConfig.getRangeIndexColumns()) {
            ColumnMetadata columnMetadata = segmentMetadata.getColumnMetadataFor(column);
            if (columnMetadata == null || columnMetadata.isSorted()) continue;
            this._rangeIndexColumns.add(columnMetadata);
        }
    }

    public void createRangeIndices() throws IOException {
        for (ColumnMetadata columnMetadata : this._rangeIndexColumns) {
            this.createRangeIndexForColumn(columnMetadata);
        }
    }

    private void createRangeIndexForColumn(ColumnMetadata columnMetadata) throws IOException {
        String column = columnMetadata.getColumnName();
        File inProgress = new File(this._indexDir, column + ".range.inprogress");
        File rangeIndexFile = new File(this._indexDir, column + ".bitmap.range");
        if (!inProgress.exists()) {
            if (this._segmentWriter.hasIndexFor(column, ColumnIndexType.RANGE_INDEX)) {
                LOGGER.info("Found range index for segment: {}, column: {}", (Object)this._segmentName, (Object)column);
                return;
            }
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)rangeIndexFile);
        }
        LOGGER.info("Creating new range index for segment: {}, column: {}", (Object)this._segmentName, (Object)column);
        if (columnMetadata.hasDictionary()) {
            this.handleDictionaryBasedColumn(columnMetadata);
        } else {
            this.handleNonDictionaryBasedColumn(columnMetadata);
        }
        if (this._segmentVersion == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(this._segmentWriter, column, rangeIndexFile, ColumnIndexType.RANGE_INDEX);
        }
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created range index for segment: {}, column: {}", (Object)this._segmentName, (Object)column);
    }

    private void handleDictionaryBasedColumn(ColumnMetadata columnMetadata) throws IOException {
        int numDocs = columnMetadata.getTotalDocs();
        try (ForwardIndexReader<?> forwardIndexReader = LoaderUtils.getForwardIndexReader((SegmentDirectory.Reader)this._segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             RangeIndexCreator rangeIndexCreator = new RangeIndexCreator(this._indexDir, columnMetadata.getFieldSpec(), FieldSpec.DataType.INT, -1, -1, numDocs, columnMetadata.getTotalNumberOfEntries());){
            if (columnMetadata.isSingleValue()) {
                for (int i = 0; i < numDocs; ++i) {
                    rangeIndexCreator.add(forwardIndexReader.getDictId(i, readerContext));
                }
            } else {
                int[] dictIds = new int[columnMetadata.getMaxNumberOfMultiValues()];
                for (int i = 0; i < numDocs; ++i) {
                    int length = forwardIndexReader.getDictIdMV(i, dictIds, readerContext);
                    rangeIndexCreator.add(dictIds, length);
                }
            }
            rangeIndexCreator.seal();
        }
    }

    private void handleNonDictionaryBasedColumn(ColumnMetadata columnMetadata) throws IOException {
        int numDocs = columnMetadata.getTotalDocs();
        try (ForwardIndexReader<?> forwardIndexReader = LoaderUtils.getForwardIndexReader((SegmentDirectory.Reader)this._segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             RangeIndexCreator rangeIndexCreator = new RangeIndexCreator(this._indexDir, columnMetadata.getFieldSpec(), columnMetadata.getDataType(), -1, -1, numDocs, columnMetadata.getTotalNumberOfEntries());){
            block39: {
                block38: {
                    if (!columnMetadata.isSingleValue()) break block38;
                    switch (columnMetadata.getDataType()) {
                        case INT: {
                            for (int i = 0; i < numDocs; ++i) {
                                rangeIndexCreator.add(forwardIndexReader.getInt(i, readerContext));
                            }
                            break block39;
                        }
                        case LONG: {
                            for (int i = 0; i < numDocs; ++i) {
                                rangeIndexCreator.add(forwardIndexReader.getLong(i, readerContext));
                            }
                            break block39;
                        }
                        case FLOAT: {
                            for (int i = 0; i < numDocs; ++i) {
                                rangeIndexCreator.add(forwardIndexReader.getFloat(i, readerContext));
                            }
                            break block39;
                        }
                        case DOUBLE: {
                            for (int i = 0; i < numDocs; ++i) {
                                rangeIndexCreator.add(forwardIndexReader.getDouble(i, readerContext));
                            }
                            break block39;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported data type: " + columnMetadata.getDataType());
                        }
                    }
                }
                int maxNumValuesPerMVEntry = columnMetadata.getMaxNumberOfMultiValues();
                switch (columnMetadata.getDataType()) {
                    case INT: {
                        int[] intValues = new int[maxNumValuesPerMVEntry];
                        for (int i = 0; i < numDocs; ++i) {
                            int length = forwardIndexReader.getIntMV(i, intValues, readerContext);
                            rangeIndexCreator.add(intValues, length);
                        }
                        break;
                    }
                    case LONG: {
                        long[] longValues = new long[maxNumValuesPerMVEntry];
                        for (int i = 0; i < numDocs; ++i) {
                            int length = forwardIndexReader.getLongMV(i, longValues, readerContext);
                            rangeIndexCreator.add(longValues, length);
                        }
                        break;
                    }
                    case FLOAT: {
                        float[] floatValues = new float[maxNumValuesPerMVEntry];
                        for (int i = 0; i < numDocs; ++i) {
                            int length = forwardIndexReader.getFloatMV(i, floatValues, readerContext);
                            rangeIndexCreator.add(floatValues, length);
                        }
                        break;
                    }
                    case DOUBLE: {
                        double[] doubleValues = new double[maxNumValuesPerMVEntry];
                        for (int i = 0; i < numDocs; ++i) {
                            int length = forwardIndexReader.getDoubleMV(i, doubleValues, readerContext);
                            rangeIndexCreator.add(doubleValues, length);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported data type: " + columnMetadata.getDataType());
                    }
                }
            }
            rangeIndexCreator.seal();
        }
    }
}

