/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.invertedindex;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.pinot.segment.local.segment.creator.impl.text.LuceneTextIndexCreator;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.local.segment.index.readers.forward.BaseChunkSVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.VarByteChunkSVForwardIndexReader;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.V1Constants;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.creator.TextIndexType;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextIndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextIndexHandler.class);
    private final File _indexDir;
    private final SegmentDirectory.Writer _segmentWriter;
    private final String _segmentName;
    private final SegmentVersion _segmentVersion;
    private final Set<ColumnMetadata> _textIndexColumns = new HashSet<ColumnMetadata>();

    public TextIndexHandler(File indexDir, SegmentMetadata segmentMetadata, Set<String> textIndexColumns, SegmentDirectory.Writer segmentWriter) {
        this._indexDir = indexDir;
        this._segmentWriter = segmentWriter;
        this._segmentName = segmentMetadata.getName();
        this._segmentVersion = segmentMetadata.getVersion();
        for (String column : textIndexColumns) {
            ColumnMetadata columnMetadata = segmentMetadata.getColumnMetadataFor(column);
            if (columnMetadata == null) continue;
            this._textIndexColumns.add(columnMetadata);
        }
    }

    public void createTextIndexesOnSegmentLoad() throws Exception {
        for (ColumnMetadata columnMetadata : this._textIndexColumns) {
            this.checkUnsupportedOperationsForTextIndex(columnMetadata);
            this.createTextIndexForColumn(columnMetadata);
        }
    }

    private void checkUnsupportedOperationsForTextIndex(ColumnMetadata columnMetadata) {
        String column = columnMetadata.getColumnName();
        if (columnMetadata.getDataType() != FieldSpec.DataType.STRING) {
            throw new UnsupportedOperationException("Text index is currently only supported on STRING columns: " + column);
        }
        if (!columnMetadata.isSingleValue()) {
            throw new UnsupportedOperationException("Text index is currently not supported on multi-value columns: " + column);
        }
    }

    private void createTextIndexForColumn(ColumnMetadata columnMetadata) throws Exception {
        String column = columnMetadata.getColumnName();
        if (this._segmentWriter.hasIndexFor(column, ColumnIndexType.TEXT_INDEX)) {
            LOGGER.info("Found text index for column: {}, in segment: {}", (Object)column, (Object)this._segmentName);
            return;
        }
        int numDocs = columnMetadata.getTotalDocs();
        boolean hasDictionary = columnMetadata.hasDictionary();
        LOGGER.info("Creating new text index for column: {} in segment: {}, hasDictionary: {}", new Object[]{column, this._segmentName, hasDictionary});
        File segmentDirectory = SegmentDirectoryPaths.segmentDirectoryFor((File)this._indexDir, (SegmentVersion)this._segmentVersion);
        try (ForwardIndexReader<?> forwardIndexReader = LoaderUtils.getForwardIndexReader((SegmentDirectory.Reader)this._segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             LuceneTextIndexCreator textIndexCreator = new LuceneTextIndexCreator(column, segmentDirectory, true);){
            if (!hasDictionary) {
                VarByteChunkSVForwardIndexReader rawIndexReader = (VarByteChunkSVForwardIndexReader)forwardIndexReader;
                BaseChunkSVForwardIndexReader.ChunkReaderContext chunkReaderContext = (BaseChunkSVForwardIndexReader.ChunkReaderContext)readerContext;
                for (int docId = 0; docId < numDocs; ++docId) {
                    textIndexCreator.add(rawIndexReader.getString(docId, chunkReaderContext));
                }
            } else {
                try (BaseImmutableDictionary dictionary = LoaderUtils.getDictionary((SegmentDirectory.Reader)this._segmentWriter, columnMetadata);){
                    for (int docId = 0; docId < numDocs; ++docId) {
                        int dictId = forwardIndexReader.getDictId(docId, readerContext);
                        textIndexCreator.add(dictionary.getStringValue(dictId));
                    }
                }
            }
            textIndexCreator.seal();
        }
        LOGGER.info("Created text index for column: {} in segment: {}", (Object)column, (Object)this._segmentName);
        PropertiesConfiguration properties = SegmentMetadataImpl.getPropertiesConfiguration((File)this._indexDir);
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"textIndexType"), (Object)TextIndexType.LUCENE.name());
        properties.save();
    }
}

