/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import java.lang.ref.SoftReference;
import java.nio.ByteOrder;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmapInvertedIndexReader
implements InvertedIndexReader<ImmutableRoaringBitmap> {
    public static final Logger LOGGER = LoggerFactory.getLogger(BitmapInvertedIndexReader.class);
    private final int _numBitmaps;
    private final PinotDataBuffer _offsetBuffer;
    private final PinotDataBuffer _bitmapBuffer;
    private final int _firstOffset;
    private volatile SoftReference<SoftReference<ImmutableRoaringBitmap>[]> _bitmaps;

    public BitmapInvertedIndexReader(PinotDataBuffer dataBuffer, int numBitmaps) {
        this._numBitmaps = numBitmaps;
        long offsetBufferEndOffset = (long)(numBitmaps + 1) * 4L;
        this._offsetBuffer = dataBuffer.view(0L, offsetBufferEndOffset, ByteOrder.BIG_ENDIAN);
        this._bitmapBuffer = dataBuffer.view(offsetBufferEndOffset, dataBuffer.size());
        this._firstOffset = this._offsetBuffer.getInt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableRoaringBitmap getDocIds(int dictId) {
        SoftReference[] bitmapArrayReference;
        if (this._bitmaps != null && (bitmapArrayReference = this._bitmaps.get()) != null) {
            ImmutableRoaringBitmap bitmap;
            SoftReference bitmapReference = bitmapArrayReference[dictId];
            if (bitmapReference != null && (bitmap = (ImmutableRoaringBitmap)bitmapReference.get()) != null) {
                return bitmap;
            }
        } else {
            bitmapArrayReference = new SoftReference[this._numBitmaps];
            this._bitmaps = new SoftReference<SoftReference[]>(bitmapArrayReference);
        }
        BitmapInvertedIndexReader bitmapInvertedIndexReader = this;
        synchronized (bitmapInvertedIndexReader) {
            ImmutableRoaringBitmap bitmap;
            SoftReference bitmapReference = bitmapArrayReference[dictId];
            if (bitmapReference == null || (bitmap = (ImmutableRoaringBitmap)bitmapReference.get()) == null) {
                bitmap = this.buildRoaringBitmap(dictId);
                bitmapArrayReference[dictId] = new SoftReference<ImmutableRoaringBitmap>(bitmap);
            }
            return bitmap;
        }
    }

    private ImmutableRoaringBitmap buildRoaringBitmap(int dictId) {
        int offset = this._offsetBuffer.getInt(dictId * 4);
        int length = this._offsetBuffer.getInt((dictId + 1) * 4) - offset;
        return new ImmutableRoaringBitmap(this._bitmapBuffer.toDirectByteBuffer((long)(offset - this._firstOffset), length));
    }

    public void close() {
    }
}

