/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class ConstantValueDoubleDictionary
extends BaseImmutableDictionary {
    private final double _value;

    public ConstantValueDoubleDictionary(double value) {
        super(1);
        this._value = value;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.DOUBLE;
    }

    public int insertionIndexOf(String stringValue) {
        double doubleValue = Double.parseDouble(stringValue);
        if (doubleValue < this._value) {
            return -1;
        }
        if (doubleValue > this._value) {
            return -2;
        }
        return 0;
    }

    @Override
    public Double getMinVal() {
        return this._value;
    }

    @Override
    public Double getMaxVal() {
        return this._value;
    }

    public double[] getSortedValues() {
        return new double[]{this._value};
    }

    public Double get(int dictId) {
        return this._value;
    }

    public int getIntValue(int dictId) {
        return (int)this._value;
    }

    public long getLongValue(int dictId) {
        return (long)this._value;
    }

    public float getFloatValue(int dictId) {
        return (float)this._value;
    }

    public double getDoubleValue(int dictId) {
        return this._value;
    }

    public String getStringValue(int dictId) {
        return Double.toString(this._value);
    }
}

