/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class ConstantValueIntDictionary
extends BaseImmutableDictionary {
    private final int _value;

    public ConstantValueIntDictionary(int value) {
        super(1);
        this._value = value;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.INT;
    }

    public int insertionIndexOf(String stringValue) {
        int intValue = Integer.parseInt(stringValue);
        if (intValue < this._value) {
            return -1;
        }
        if (intValue > this._value) {
            return -2;
        }
        return 0;
    }

    @Override
    public Integer getMinVal() {
        return this._value;
    }

    @Override
    public Integer getMaxVal() {
        return this._value;
    }

    public int[] getSortedValues() {
        return new int[]{this._value};
    }

    public Integer get(int dictId) {
        return this._value;
    }

    public int getIntValue(int dictId) {
        return this._value;
    }

    public long getLongValue(int dictId) {
        return this._value;
    }

    public float getFloatValue(int dictId) {
        return this._value;
    }

    public double getDoubleValue(int dictId) {
        return this._value;
    }

    public String getStringValue(int dictId) {
        return Integer.toString(this._value);
    }
}

