/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class ConstantValueLongDictionary
extends BaseImmutableDictionary {
    private final long _value;

    public ConstantValueLongDictionary(long value) {
        super(1);
        this._value = value;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.LONG;
    }

    public int insertionIndexOf(String stringValue) {
        long longValue = Long.parseLong(stringValue);
        if (longValue < this._value) {
            return -1;
        }
        if (longValue > this._value) {
            return -2;
        }
        return 0;
    }

    @Override
    public Long getMinVal() {
        return this._value;
    }

    @Override
    public Long getMaxVal() {
        return this._value;
    }

    public long[] getSortedValues() {
        return new long[]{this._value};
    }

    public Long get(int dictId) {
        return this._value;
    }

    public int getIntValue(int dictId) {
        return (int)this._value;
    }

    public long getLongValue(int dictId) {
        return this._value;
    }

    public float getFloatValue(int dictId) {
        return this._value;
    }

    public double getDoubleValue(int dictId) {
        return this._value;
    }

    public String getStringValue(int dictId) {
        return Long.toString(this._value);
    }
}

