/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public class LongDictionary
extends BaseImmutableDictionary {
    public LongDictionary(PinotDataBuffer dataBuffer, int length) {
        super(dataBuffer, length, 8, (byte)0);
    }

    public int insertionIndexOf(String stringValue) {
        return this.binarySearch(Long.parseLong(stringValue));
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.LONG;
    }

    public Long get(int dictId) {
        return this.getLong(dictId);
    }

    public int getIntValue(int dictId) {
        return (int)this.getLong(dictId);
    }

    public long getLongValue(int dictId) {
        return this.getLong(dictId);
    }

    public float getFloatValue(int dictId) {
        return this.getLong(dictId);
    }

    public double getDoubleValue(int dictId) {
        return this.getLong(dictId);
    }

    public String getStringValue(int dictId) {
        return Long.toString(this.getLong(dictId));
    }
}

