/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeIndexReader
implements InvertedIndexReader<ImmutableRoaringBitmap> {
    public static final Logger LOGGER = LoggerFactory.getLogger(RangeIndexReader.class);
    private final PinotDataBuffer _dataBuffer;
    private final FieldSpec.DataType _valueType;
    private final int _numRanges;
    final long _bitmapIndexOffset;
    private final Number[] _rangeStartArray;
    private final Number _lastRangeEnd;
    private volatile SoftReference<SoftReference<ImmutableRoaringBitmap>[]> _bitmaps;

    public RangeIndexReader(PinotDataBuffer dataBuffer) {
        this._dataBuffer = dataBuffer;
        long offset = 0L;
        int version = dataBuffer.getInt(offset);
        int valueTypeBytesLength = dataBuffer.getInt(offset += 4L);
        byte[] valueTypeBytes = new byte[valueTypeBytesLength];
        dataBuffer.copyTo(offset += 4L, valueTypeBytes);
        this._valueType = FieldSpec.DataType.valueOf((String)new String(valueTypeBytes));
        this._numRanges = dataBuffer.getInt(offset += (long)valueTypeBytesLength);
        long rangeArrayStartOffset = offset += 4L;
        this._rangeStartArray = new Number[this._numRanges];
        long lastOffset = dataBuffer.getLong(offset + (long)((this._numRanges + 1) * this._valueType.size()) + (long)(this._numRanges * 8));
        this._bitmapIndexOffset = offset + (long)((this._numRanges + 1) * this._valueType.size());
        Preconditions.checkState((lastOffset == dataBuffer.size() ? 1 : 0) != 0, (Object)("The last offset should be equal to buffer size! Current lastOffset: " + lastOffset + ", buffer size: " + dataBuffer.size()));
        switch (this._valueType) {
            case INT: {
                for (int i = 0; i < this._numRanges; ++i) {
                    this._rangeStartArray[i] = dataBuffer.getInt(rangeArrayStartOffset + (long)(i * 4));
                }
                this._lastRangeEnd = dataBuffer.getInt(rangeArrayStartOffset + (long)(this._numRanges * 4));
                break;
            }
            case LONG: {
                for (int i = 0; i < this._numRanges; ++i) {
                    this._rangeStartArray[i] = dataBuffer.getLong(rangeArrayStartOffset + (long)(i * 8));
                }
                this._lastRangeEnd = dataBuffer.getLong(rangeArrayStartOffset + (long)(this._numRanges * 8));
                break;
            }
            case FLOAT: {
                for (int i = 0; i < this._numRanges; ++i) {
                    this._rangeStartArray[i] = Float.valueOf(dataBuffer.getFloat(rangeArrayStartOffset + (long)(i * 4)));
                }
                this._lastRangeEnd = Float.valueOf(dataBuffer.getFloat(rangeArrayStartOffset + (long)(this._numRanges * 4)));
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < this._numRanges; ++i) {
                    this._rangeStartArray[i] = dataBuffer.getDouble(rangeArrayStartOffset + (long)(i * 8));
                }
                this._lastRangeEnd = dataBuffer.getDouble(rangeArrayStartOffset + (long)(this._numRanges * 8));
                break;
            }
            default: {
                throw new RuntimeException("Range Index Unsupported for dataType:" + this._valueType);
            }
        }
    }

    @VisibleForTesting
    public Number[] getRangeStartArray() {
        return this._rangeStartArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableRoaringBitmap getDocIds(int rangeId) {
        ImmutableRoaringBitmap value;
        SoftReference[] bitmapArrayReference = null;
        if (this._bitmaps != null) {
            bitmapArrayReference = this._bitmaps.get();
            if (bitmapArrayReference != null) {
                SoftReference bitmapReference = bitmapArrayReference[rangeId];
                if (bitmapReference != null && (value = (ImmutableRoaringBitmap)bitmapReference.get()) != null) {
                    return value;
                }
            } else {
                bitmapArrayReference = new SoftReference[this._numRanges];
                this._bitmaps = new SoftReference<SoftReference[]>(bitmapArrayReference);
            }
        } else {
            bitmapArrayReference = new SoftReference[this._numRanges];
            this._bitmaps = new SoftReference<SoftReference[]>(bitmapArrayReference);
        }
        RangeIndexReader rangeIndexReader = this;
        synchronized (rangeIndexReader) {
            if (bitmapArrayReference[rangeId] == null || bitmapArrayReference[rangeId].get() == null) {
                value = this.buildRoaringBitmapForIndex(rangeId);
                bitmapArrayReference[rangeId] = new SoftReference<ImmutableRoaringBitmap>(value);
            } else {
                value = (ImmutableRoaringBitmap)bitmapArrayReference[rangeId].get();
            }
            return value;
        }
    }

    private synchronized ImmutableRoaringBitmap buildRoaringBitmapForIndex(int rangeId) {
        long currentOffset = this.getOffset(rangeId);
        long nextOffset = this.getOffset(rangeId + 1);
        int bufferLength = (int)(nextOffset - currentOffset);
        ByteBuffer bb = this._dataBuffer.toDirectByteBuffer(currentOffset, bufferLength);
        return new ImmutableRoaringBitmap(bb);
    }

    private long getOffset(int rangeId) {
        return this._dataBuffer.getLong(this._bitmapIndexOffset + (long)(rangeId * 8));
    }

    public int findRangeId(int value) {
        for (int i = 0; i < this._rangeStartArray.length; ++i) {
            if (value >= this._rangeStartArray[i].intValue()) continue;
            return i - 1;
        }
        if (value <= this._lastRangeEnd.intValue()) {
            return this._rangeStartArray.length - 1;
        }
        return -1;
    }

    public int findRangeId(long value) {
        for (int i = 0; i < this._rangeStartArray.length; ++i) {
            if (value >= this._rangeStartArray[i].longValue()) continue;
            return i - 1;
        }
        if (value <= this._lastRangeEnd.longValue()) {
            return this._rangeStartArray.length - 1;
        }
        return -1;
    }

    public int findRangeId(float value) {
        for (int i = 0; i < this._rangeStartArray.length; ++i) {
            if (!(value < this._rangeStartArray[i].floatValue())) continue;
            return i - 1;
        }
        if (value <= this._lastRangeEnd.floatValue()) {
            return this._rangeStartArray.length - 1;
        }
        return -1;
    }

    public int findRangeId(double value) {
        for (int i = 0; i < this._rangeStartArray.length; ++i) {
            if (!(value < this._rangeStartArray[i].doubleValue())) continue;
            return i - 1;
        }
        if (value <= this._lastRangeEnd.doubleValue()) {
            return this._rangeStartArray.length - 1;
        }
        return -1;
    }

    public void close() {
    }
}

