/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BytesUtils;

public class StringDictionary
extends BaseImmutableDictionary {
    public StringDictionary(PinotDataBuffer dataBuffer, int length, int numBytesPerValue, byte paddingByte) {
        super(dataBuffer, length, numBytesPerValue, paddingByte);
    }

    public int insertionIndexOf(String stringValue) {
        return this.binarySearch(stringValue);
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.STRING;
    }

    public String get(int dictId) {
        return this.getUnpaddedString(dictId, this.getBuffer());
    }

    public int getIntValue(int dictId) {
        return Integer.parseInt(this.getUnpaddedString(dictId, this.getBuffer()));
    }

    public long getLongValue(int dictId) {
        return Long.parseLong(this.getUnpaddedString(dictId, this.getBuffer()));
    }

    public float getFloatValue(int dictId) {
        return Float.parseFloat(this.getUnpaddedString(dictId, this.getBuffer()));
    }

    public double getDoubleValue(int dictId) {
        return Double.parseDouble(this.getUnpaddedString(dictId, this.getBuffer()));
    }

    public String getStringValue(int dictId) {
        return this.getUnpaddedString(dictId, this.getBuffer());
    }

    public byte[] getBytesValue(int dictId) {
        return BytesUtils.toBytes((String)this.getUnpaddedString(dictId, this.getBuffer()));
    }

    public void readIntValues(int[] dictIds, int length, int[] outValues) {
        byte[] buffer = this.getBuffer();
        for (int i = 0; i < length; ++i) {
            outValues[i] = Integer.parseInt(this.getUnpaddedString(dictIds[i], buffer));
        }
    }

    public void readLongValues(int[] dictIds, int length, long[] outValues) {
        byte[] buffer = this.getBuffer();
        for (int i = 0; i < length; ++i) {
            outValues[i] = Long.parseLong(this.getUnpaddedString(dictIds[i], buffer));
        }
    }

    public void readFloatValues(int[] dictIds, int length, float[] outValues) {
        byte[] buffer = this.getBuffer();
        for (int i = 0; i < length; ++i) {
            outValues[i] = Float.parseFloat(this.getUnpaddedString(dictIds[i], buffer));
        }
    }

    public void readDoubleValues(int[] dictIds, int length, double[] outValues) {
        byte[] buffer = this.getBuffer();
        for (int i = 0; i < length; ++i) {
            outValues[i] = Double.parseDouble(this.getUnpaddedString(dictIds[i], buffer));
        }
    }

    public void readStringValues(int[] dictIds, int length, String[] outValues) {
        byte[] buffer = this.getBuffer();
        for (int i = 0; i < length; ++i) {
            outValues[i] = this.getUnpaddedString(dictIds[i], buffer);
        }
    }

    public void readBytesValues(int[] dictIds, int length, byte[][] outValues) {
        byte[] buffer = this.getBuffer();
        for (int i = 0; i < length; ++i) {
            outValues[i] = BytesUtils.toBytes((String)this.getUnpaddedString(dictIds[i], buffer));
        }
    }
}

