/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.bloom;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import org.apache.pinot.spi.utils.StringUtils;

public class GuavaBloomFilterReaderUtils {
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_128();

    private GuavaBloomFilterReaderUtils() {
    }

    public static byte[] hash(String value) {
        return HASH_FUNCTION.hashBytes(StringUtils.encodeUtf8((String)value)).asBytes();
    }

    public static double computeFPP(int sizeInBytes, int numInsertions) {
        double b = (double)sizeInBytes * 8.0 / (double)numInsertions;
        double k = b * Math.log(2.0);
        return Math.pow(2.0, -k);
    }
}

