/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.forward;

import org.apache.pinot.segment.local.io.util.FixedBitIntReaderWriter;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public final class FixedBitSVForwardIndexReader
implements ForwardIndexReader<ForwardIndexReaderContext> {
    private final FixedBitIntReaderWriter _reader;

    public FixedBitSVForwardIndexReader(PinotDataBuffer dataBuffer, int numDocs, int numBitsPerValue) {
        this._reader = new FixedBitIntReaderWriter(dataBuffer, numDocs, numBitsPerValue);
    }

    public boolean isDictionaryEncoded() {
        return true;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.INT;
    }

    public int getDictId(int docId, ForwardIndexReaderContext context) {
        return this._reader.readInt(docId);
    }

    public void readDictIds(int[] docIds, int length, int[] dictIdBuffer, ForwardIndexReaderContext context) {
        for (int i = 0; i < length; ++i) {
            dictIdBuffer[i] = this._reader.readInt(docIds[i]);
        }
    }

    public void close() {
        this._reader.close();
    }
}

