/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.readers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.apache.pinot.spi.utils.ByteArray;

public class MultiplePinotSegmentRecordReader
implements RecordReader {
    private final List<PinotSegmentRecordReader> _recordReaders;
    private final List<String> _sortOrder;
    private final PriorityQueue<GenericRowWithReader> _priorityQueue;
    private int _currentReaderId;

    public MultiplePinotSegmentRecordReader(List<File> indexDirs) throws Exception {
        this(indexDirs, null, null);
    }

    public MultiplePinotSegmentRecordReader(List<File> indexDirs, @Nullable Set<String> fieldsToRead, @Nullable List<String> sortOrder) throws Exception {
        int numSegments = indexDirs.size();
        this._recordReaders = new ArrayList<PinotSegmentRecordReader>(numSegments);
        for (File indexDir : indexDirs) {
            PinotSegmentRecordReader recordReader = new PinotSegmentRecordReader();
            recordReader.init(indexDir, fieldsToRead, sortOrder, false);
            this._recordReaders.add(recordReader);
        }
        if (CollectionUtils.isNotEmpty(sortOrder)) {
            this._sortOrder = sortOrder;
            this._priorityQueue = new PriorityQueue(numSegments);
            for (PinotSegmentRecordReader recordReader : this._recordReaders) {
                if (!recordReader.hasNext()) continue;
                this._priorityQueue.add(new GenericRowWithReader(recordReader.next(), recordReader));
            }
        } else {
            this._sortOrder = null;
            this._priorityQueue = null;
        }
    }

    public void init(File dataFile, Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) {
    }

    public boolean hasNext() {
        if (this._sortOrder != null) {
            return this._priorityQueue.size() > 0;
        }
        for (PinotSegmentRecordReader recordReader : this._recordReaders) {
            if (!recordReader.hasNext()) continue;
            return true;
        }
        return false;
    }

    public GenericRow next() {
        return this.next(new GenericRow());
    }

    public GenericRow next(GenericRow reuse) {
        if (this._sortOrder != null) {
            GenericRowWithReader genericRowComparable = this._priorityQueue.poll();
            assert (genericRowComparable != null);
            GenericRow currentRow = genericRowComparable.getRow();
            reuse.init(currentRow);
            PinotSegmentRecordReader recordReader = genericRowComparable.getRecordReader();
            if (recordReader.hasNext()) {
                currentRow.clear();
                this._priorityQueue.add(new GenericRowWithReader(recordReader.next(currentRow), recordReader));
            }
            return reuse;
        }
        int numSegments = this._recordReaders.size();
        for (int i = 0; i < numSegments; ++i) {
            PinotSegmentRecordReader currentReader = this._recordReaders.get(this._currentReaderId);
            if (currentReader.hasNext()) {
                return currentReader.next(reuse);
            }
            this._currentReaderId = (this._currentReaderId + 1) % numSegments;
        }
        throw new RuntimeException("next is called after reading all data");
    }

    public void rewind() {
        for (PinotSegmentRecordReader recordReader : this._recordReaders) {
            recordReader.rewind();
        }
        if (this._sortOrder != null) {
            this._priorityQueue.clear();
            for (PinotSegmentRecordReader recordReader : this._recordReaders) {
                if (!recordReader.hasNext()) continue;
                this._priorityQueue.add(new GenericRowWithReader(recordReader.next(), recordReader));
            }
        } else {
            this._currentReaderId = 0;
        }
    }

    public void close() throws IOException {
        for (PinotSegmentRecordReader recordReader : this._recordReaders) {
            recordReader.close();
        }
    }

    private class GenericRowWithReader
    implements Comparable<GenericRowWithReader> {
        private final GenericRow _row;
        private final PinotSegmentRecordReader _recordReader;

        GenericRowWithReader(GenericRow row, PinotSegmentRecordReader recordReader) {
            this._row = row;
            this._recordReader = recordReader;
        }

        @Override
        public int compareTo(GenericRowWithReader other) {
            for (String column : MultiplePinotSegmentRecordReader.this._sortOrder) {
                Object thisVal = this._row.getValue(column);
                Object otherVal = other.getRow().getValue(column);
                int result = thisVal instanceof byte[] ? ByteArray.compare((byte[])((byte[])thisVal), (byte[])((byte[])otherVal)) : ((Comparable)thisVal).compareTo(otherVal);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        public GenericRow getRow() {
            return this._row;
        }

        public PinotSegmentRecordReader getRecordReader() {
            return this._recordReader;
        }
    }
}

