/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.store;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.segment.local.segment.store.IndexKey;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.ColumnIndexDirectory;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.spi.utils.ReadMode;

class FilePerIndexDirectory
extends ColumnIndexDirectory {
    private final File _segmentDirectory;
    private SegmentMetadataImpl _segmentMetadata;
    private final ReadMode _readMode;
    private final Map<IndexKey, PinotDataBuffer> indexBuffers = new HashMap<IndexKey, PinotDataBuffer>();

    protected FilePerIndexDirectory(File segmentDirectory, SegmentMetadataImpl segmentMetadata, ReadMode readMode) {
        Preconditions.checkNotNull((Object)segmentDirectory);
        Preconditions.checkNotNull((Object)readMode);
        Preconditions.checkNotNull((Object)segmentMetadata);
        Preconditions.checkArgument((boolean)segmentDirectory.exists(), (Object)("SegmentDirectory: " + segmentDirectory.toString() + " does not exist"));
        Preconditions.checkArgument((boolean)segmentDirectory.isDirectory(), (Object)("SegmentDirectory: " + segmentDirectory.toString() + " is not a directory"));
        this._segmentDirectory = segmentDirectory;
        this._segmentMetadata = segmentMetadata;
        this._readMode = readMode;
    }

    public void setSegmentMetadata(SegmentMetadataImpl segmentMetadata) {
        this._segmentMetadata = segmentMetadata;
    }

    public PinotDataBuffer getBuffer(String column, ColumnIndexType type) throws IOException {
        IndexKey key = new IndexKey(column, type);
        return this.getReadBufferFor(key);
    }

    public PinotDataBuffer newBuffer(String column, ColumnIndexType type, long sizeBytes) throws IOException {
        IndexKey key = new IndexKey(column, type);
        return this.getWriteBufferFor(key, sizeBytes);
    }

    public boolean hasIndexFor(String column, ColumnIndexType type) {
        File indexFile = this.getFileFor(column, type);
        return indexFile.exists();
    }

    public void close() throws IOException {
        for (PinotDataBuffer dataBuffer : this.indexBuffers.values()) {
            dataBuffer.close();
        }
    }

    public void removeIndex(String columnName, ColumnIndexType indexType) {
        File indexFile = this.getFileFor(columnName, indexType);
        indexFile.delete();
    }

    public boolean isIndexRemovalSupported() {
        return true;
    }

    private PinotDataBuffer getReadBufferFor(IndexKey key) throws IOException {
        if (this.indexBuffers.containsKey(key)) {
            return this.indexBuffers.get(key);
        }
        File file = this.getFileFor(key.name, key.type);
        if (!file.exists()) {
            throw new RuntimeException("Could not find index for column: " + key.name + ", type: " + key.type + ", segment: " + this._segmentDirectory.toString());
        }
        PinotDataBuffer buffer = this.mapForReads(file, key.type.toString() + ".reader");
        this.indexBuffers.put(key, buffer);
        return buffer;
    }

    private PinotDataBuffer getWriteBufferFor(IndexKey key, long sizeBytes) throws IOException {
        if (this.indexBuffers.containsKey(key)) {
            return this.indexBuffers.get(key);
        }
        File filename = this.getFileFor(key.name, key.type);
        PinotDataBuffer buffer = this.mapForWrites(filename, sizeBytes, key.type.toString() + ".writer");
        this.indexBuffers.put(key, buffer);
        return buffer;
    }

    @VisibleForTesting
    File getFileFor(String column, ColumnIndexType indexType) {
        String fileExtension;
        switch (indexType) {
            case DICTIONARY: {
                fileExtension = ".dict";
                break;
            }
            case FORWARD_INDEX: {
                ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
                if (columnMetadata.isSingleValue()) {
                    if (!columnMetadata.hasDictionary()) {
                        fileExtension = ".sv.raw.fwd";
                        break;
                    }
                    if (columnMetadata.isSorted()) {
                        fileExtension = ".sv.sorted.fwd";
                        break;
                    }
                    fileExtension = ".sv.unsorted.fwd";
                    break;
                }
                fileExtension = ".mv.fwd";
                break;
            }
            case INVERTED_INDEX: {
                fileExtension = ".bitmap.inv";
                break;
            }
            case RANGE_INDEX: {
                fileExtension = ".bitmap.range";
                break;
            }
            case BLOOM_FILTER: {
                fileExtension = ".bloom";
                break;
            }
            case NULLVALUE_VECTOR: {
                fileExtension = ".bitmap.nullvalue";
                break;
            }
            case TEXT_INDEX: {
                fileExtension = ".lucene.index";
                break;
            }
            case FST_INDEX: {
                fileExtension = ".lucene.fst";
                break;
            }
            case JSON_INDEX: {
                fileExtension = ".json.idx";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported index type: " + indexType);
            }
        }
        return new File(this._segmentDirectory, column + fileExtension);
    }

    private PinotDataBuffer mapForWrites(File file, long sizeBytes, String context) throws IOException {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkArgument((sizeBytes >= 0L && sizeBytes < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)("File size must be less than 2GB, file: " + file));
        Preconditions.checkState((!file.exists() ? 1 : 0) != 0, (Object)("File: " + file + " already exists"));
        String allocationContext = this.allocationContext(file, context);
        return PinotDataBuffer.mapFile((File)file, (boolean)false, (long)0L, (long)sizeBytes, (ByteOrder)ByteOrder.BIG_ENDIAN, (String)allocationContext);
    }

    private PinotDataBuffer mapForReads(File file, String context) throws IOException {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((boolean)file.exists(), (Object)("File: " + file + " must exist"));
        Preconditions.checkArgument((boolean)file.isFile(), (Object)("File: " + file + " must be a regular file"));
        String allocationContext = this.allocationContext(file, context);
        if (this._readMode == ReadMode.heap) {
            return PinotDataBuffer.loadFile((File)file, (long)0L, (long)file.length(), (ByteOrder)ByteOrder.BIG_ENDIAN, (String)allocationContext);
        }
        return PinotDataBuffer.mapFile((File)file, (boolean)true, (long)0L, (long)file.length(), (ByteOrder)ByteOrder.BIG_ENDIAN, (String)allocationContext);
    }
}

