/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.startree.v2.store;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.pinot.segment.local.startree.v2.store.StarTreeIndexMapUtils;
import org.apache.pinot.segment.local.startree.v2.store.StarTreeLoaderUtils;
import org.apache.pinot.segment.spi.index.column.ColumnIndexContainer;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.utils.ReadMode;

public class StarTreeIndexContainer
implements Closeable {
    private final PinotDataBuffer _dataBuffer;
    private final List<StarTreeV2> _starTrees;

    public StarTreeIndexContainer(File segmentDirectory, SegmentMetadataImpl segmentMetadata, Map<String, ColumnIndexContainer> indexContainerMap, ReadMode readMode) throws ConfigurationException, IOException {
        File indexFile = new File(segmentDirectory, "star_tree_index");
        this._dataBuffer = readMode == ReadMode.heap ? PinotDataBuffer.loadFile((File)indexFile, (long)0L, (long)indexFile.length(), (ByteOrder)ByteOrder.LITTLE_ENDIAN, (String)"Star-tree V2 data buffer") : PinotDataBuffer.mapFile((File)indexFile, (boolean)true, (long)0L, (long)indexFile.length(), (ByteOrder)ByteOrder.LITTLE_ENDIAN, (String)"Star-tree V2 data buffer");
        File indexMapFile = new File(segmentDirectory, "star_tree_index_map");
        List<Map<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue>> indexMapList = StarTreeIndexMapUtils.loadFromFile(indexMapFile, segmentMetadata.getStarTreeV2MetadataList().size());
        this._starTrees = StarTreeLoaderUtils.loadStarTreeV2(this._dataBuffer, indexMapList, segmentMetadata, indexContainerMap);
    }

    public List<StarTreeV2> getStarTrees() {
        return this._starTrees;
    }

    @Override
    public void close() throws IOException {
        this._dataBuffer.close();
    }
}

