/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.pinot.segment.local.upsert.merger.PartialUpsertMerger;
import org.apache.pinot.segment.local.upsert.merger.PartialUpsertMergerFactory;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialUpsertHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartialUpsertHandler.class);
    private final Map<String, PartialUpsertMerger> _column2Mergers = new HashMap<String, PartialUpsertMerger>();
    private final HelixManager _helixManager;
    private final String _tableNameWithType;
    private boolean _allSegmentsLoaded;

    public PartialUpsertHandler(HelixManager helixManager, String tableNameWithType, Map<String, UpsertConfig.Strategy> partialUpsertStrategies) {
        this._helixManager = helixManager;
        this._tableNameWithType = tableNameWithType;
        for (Map.Entry<String, UpsertConfig.Strategy> entry : partialUpsertStrategies.entrySet()) {
            this._column2Mergers.put(entry.getKey(), PartialUpsertMergerFactory.getMerger(entry.getValue()));
        }
    }

    public synchronized boolean isAllSegmentsLoaded() {
        PropertyKey.Builder keyBuilder;
        if (this._allSegmentsLoaded) {
            return true;
        }
        HelixDataAccessor dataAccessor = this._helixManager.getHelixDataAccessor();
        IdealState idealState = (IdealState)dataAccessor.getProperty((keyBuilder = dataAccessor.keyBuilder()).idealStates(this._tableNameWithType));
        if (idealState == null) {
            LOGGER.warn("Failed to find ideal state for table: {}", (Object)this._tableNameWithType);
            return false;
        }
        String instanceName = this._helixManager.getInstanceName();
        LiveInstance liveInstance = (LiveInstance)dataAccessor.getProperty(keyBuilder.liveInstance(instanceName));
        if (liveInstance == null) {
            LOGGER.warn("Failed to find live instance for instance: {}", (Object)instanceName);
            return false;
        }
        String sessionId = liveInstance.getEphemeralOwner();
        CurrentState currentState = (CurrentState)dataAccessor.getProperty(keyBuilder.currentState(instanceName, sessionId, this._tableNameWithType));
        if (currentState == null) {
            LOGGER.warn("Failed to find current state for instance: {}, sessionId: {}, table: {}", new Object[]{instanceName, sessionId, this._tableNameWithType});
            return false;
        }
        Map idealStatesMap = idealState.getRecord().getMapFields();
        Map currentStateMap = currentState.getPartitionStateMap();
        for (Map.Entry entry : idealStatesMap.entrySet()) {
            String actualState;
            String segmentName = (String)entry.getKey();
            Map instanceStateMap = (Map)entry.getValue();
            String expectedState = (String)instanceStateMap.get(instanceName);
            if (!"ONLINE".equals(expectedState) || "ONLINE".equals(actualState = (String)currentStateMap.get(segmentName))) continue;
            if ("ERROR".equals(actualState)) {
                LOGGER.error("Find ERROR segment: {}, table: {}, expected: {}", new Object[]{segmentName, this._tableNameWithType, expectedState});
            } else {
                LOGGER.info("Find unloaded segment: {}, table: {}, expected: {}, actual: {}", new Object[]{segmentName, this._tableNameWithType, expectedState, actualState});
            }
            return false;
        }
        LOGGER.info("All segments loaded for table: {}", (Object)this._tableNameWithType);
        this._allSegmentsLoaded = true;
        return true;
    }

    public GenericRow merge(GenericRow previousRecord, GenericRow newRecord) {
        for (Map.Entry<String, PartialUpsertMerger> entry : this._column2Mergers.entrySet()) {
            String column = entry.getKey();
            if (previousRecord.isNullValue(column)) continue;
            if (newRecord.isNullValue(column)) {
                newRecord.putValue(column, previousRecord.getValue(column));
                newRecord.removeNullValueField(column);
                continue;
            }
            newRecord.putValue(column, entry.getValue().merge(previousRecord.getValue(column), newRecord.getValue(column)));
        }
        return newRecord;
    }
}

