/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.segment.local.upsert.PartialUpsertHandler;
import org.apache.pinot.segment.local.upsert.RecordLocation;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.index.ThreadSafeMutableRoaringBitmap;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PartitionUpsertMetadataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionUpsertMetadataManager.class);
    private final String _tableNameWithType;
    private final int _partitionId;
    private final ServerMetrics _serverMetrics;
    private final PartialUpsertHandler _partialUpsertHandler;
    @VisibleForTesting
    final ConcurrentHashMap<PrimaryKey, RecordLocation> _primaryKeyToRecordLocationMap = new ConcurrentHashMap();
    private final GenericRow _reuse = new GenericRow();
    private GenericRow _result;

    public PartitionUpsertMetadataManager(String tableNameWithType, int partitionId, ServerMetrics serverMetrics, @Nullable PartialUpsertHandler partialUpsertHandler) {
        this._tableNameWithType = tableNameWithType;
        this._partitionId = partitionId;
        this._serverMetrics = serverMetrics;
        this._partialUpsertHandler = partialUpsertHandler;
    }

    public void addSegment(IndexSegment segment, Iterator<RecordInfo> recordInfoIterator) {
        String segmentName = segment.getSegmentName();
        LOGGER.info("Adding upsert metadata for segment: {}", (Object)segmentName);
        ThreadSafeMutableRoaringBitmap validDocIds = segment.getValidDocIds();
        assert (validDocIds != null);
        while (recordInfoIterator.hasNext()) {
            RecordInfo recordInfo = recordInfoIterator.next();
            this._primaryKeyToRecordLocationMap.compute(recordInfo._primaryKey, (primaryKey, currentRecordLocation) -> {
                if (currentRecordLocation != null) {
                    IndexSegment currentSegment = currentRecordLocation.getSegment();
                    if (segment == currentSegment) {
                        if (recordInfo._timestamp >= currentRecordLocation.getTimestamp()) {
                            validDocIds.remove(currentRecordLocation.getDocId());
                            validDocIds.add(recordInfo._docId);
                            return new RecordLocation(segment, recordInfo._docId, recordInfo._timestamp);
                        }
                        return currentRecordLocation;
                    }
                    String currentSegmentName = currentSegment.getSegmentName();
                    if (segmentName.equals(currentSegmentName)) {
                        if (recordInfo._timestamp >= currentRecordLocation.getTimestamp()) {
                            validDocIds.add(recordInfo._docId);
                            return new RecordLocation(segment, recordInfo._docId, recordInfo._timestamp);
                        }
                        return currentRecordLocation;
                    }
                    if (recordInfo._timestamp > currentRecordLocation.getTimestamp() || recordInfo._timestamp == currentRecordLocation.getTimestamp() && LLCSegmentName.isLowLevelConsumerSegmentName((String)segmentName) && LLCSegmentName.isLowLevelConsumerSegmentName((String)currentSegmentName) && LLCSegmentName.getSequenceNumber((String)segmentName) > LLCSegmentName.getSequenceNumber((String)currentSegmentName)) {
                        assert (currentSegment.getValidDocIds() != null);
                        currentSegment.getValidDocIds().remove(currentRecordLocation.getDocId());
                        validDocIds.add(recordInfo._docId);
                        return new RecordLocation(segment, recordInfo._docId, recordInfo._timestamp);
                    }
                    return currentRecordLocation;
                }
                validDocIds.add(recordInfo._docId);
                return new RecordLocation(segment, recordInfo._docId, recordInfo._timestamp);
            });
        }
        this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.UPSERT_PRIMARY_KEYS_COUNT, (long)this._primaryKeyToRecordLocationMap.size());
    }

    public GenericRow updateRecord(IndexSegment segment, RecordInfo recordInfo, GenericRow record) {
        if (this._partialUpsertHandler != null) {
            while (!this._partialUpsertHandler.isAllSegmentsLoaded()) {
                LOGGER.info("Sleeping 1 second waiting for all segments loaded for partial-upsert table: {}", (Object)this._tableNameWithType);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this._result = record;
        this._primaryKeyToRecordLocationMap.compute(recordInfo._primaryKey, (primaryKey, currentRecordLocation) -> {
            if (currentRecordLocation != null) {
                if (recordInfo._timestamp >= currentRecordLocation.getTimestamp()) {
                    IndexSegment currentSegment = currentRecordLocation.getSegment();
                    if (this._partialUpsertHandler != null) {
                        GenericRow previousRecord = currentSegment.getRecord(currentRecordLocation.getDocId(), this._reuse);
                        this._result = this._partialUpsertHandler.merge(previousRecord, record);
                    }
                    assert (currentSegment.getValidDocIds() != null);
                    currentSegment.getValidDocIds().remove(currentRecordLocation.getDocId());
                    assert (segment.getValidDocIds() != null);
                    segment.getValidDocIds().add(recordInfo._docId);
                    return new RecordLocation(segment, recordInfo._docId, recordInfo._timestamp);
                }
                if (this._partialUpsertHandler != null) {
                    LOGGER.warn("Got late event for partial upsert: {} (current timestamp: {}, record timestamp: {}), skipping updating the record", new Object[]{record, currentRecordLocation.getTimestamp(), recordInfo._timestamp});
                }
                return currentRecordLocation;
            }
            assert (segment.getValidDocIds() != null);
            segment.getValidDocIds().add(recordInfo._docId);
            return new RecordLocation(segment, recordInfo._docId, recordInfo._timestamp);
        });
        this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.UPSERT_PRIMARY_KEYS_COUNT, (long)this._primaryKeyToRecordLocationMap.size());
        return this._result;
    }

    public void removeSegment(IndexSegment segment) {
        String segmentName = segment.getSegmentName();
        LOGGER.info("Removing upsert metadata for segment: {}", (Object)segmentName);
        assert (segment.getValidDocIds() != null);
        if (!segment.getValidDocIds().getMutableRoaringBitmap().isEmpty()) {
            this._primaryKeyToRecordLocationMap.forEach((primaryKey, recordLocation) -> {
                if (recordLocation.getSegment() == segment) {
                    this._primaryKeyToRecordLocationMap.remove(primaryKey, recordLocation);
                }
            });
        }
        this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.UPSERT_PRIMARY_KEYS_COUNT, (long)this._primaryKeyToRecordLocationMap.size());
    }

    public static final class RecordInfo {
        private final PrimaryKey _primaryKey;
        private final int _docId;
        private final long _timestamp;

        public RecordInfo(PrimaryKey primaryKey, int docId, long timestamp) {
            this._primaryKey = primaryKey;
            this._docId = docId;
            this._timestamp = timestamp;
        }
    }
}

