/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert.merger;

import org.apache.pinot.segment.local.upsert.merger.AppendMerger;
import org.apache.pinot.segment.local.upsert.merger.IncrementMerger;
import org.apache.pinot.segment.local.upsert.merger.OverwriteMerger;
import org.apache.pinot.segment.local.upsert.merger.PartialUpsertMerger;
import org.apache.pinot.segment.local.upsert.merger.UnionMerger;
import org.apache.pinot.spi.config.table.UpsertConfig;

public class PartialUpsertMergerFactory {
    private static final AppendMerger APPEND_MERGER = new AppendMerger();
    private static final IncrementMerger INCREMENT_MERGER = new IncrementMerger();
    private static final OverwriteMerger OVERWRITE_MERGER = new OverwriteMerger();
    private static final UnionMerger UNION_MERGER = new UnionMerger();

    private PartialUpsertMergerFactory() {
    }

    public static PartialUpsertMerger getMerger(UpsertConfig.Strategy strategy) {
        switch (strategy) {
            case APPEND: {
                return APPEND_MERGER;
            }
            case INCREMENT: {
                return INCREMENT_MERGER;
            }
            case OVERWRITE: {
                return OVERWRITE_MERGER;
            }
            case UNION: {
                return UNION_MERGER;
            }
        }
        throw new IllegalStateException("Unsupported partial upsert strategy: " + strategy);
    }
}

