/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.Arrays;
import org.apache.pinot.segment.local.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.segment.local.io.readerwriter.impl.FixedByteSingleValueMultiColumnReaderWriter;
import org.apache.pinot.segment.local.realtime.impl.dictionary.BaseOffHeapMutableDictionary;
import org.apache.pinot.segment.local.utils.IdMap;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.FixedIntArray;

public class FixedIntArrayOffHeapIdMap
extends BaseOffHeapMutableDictionary
implements IdMap<FixedIntArray> {
    private final FixedByteSingleValueMultiColumnReaderWriter _dictIdToValue;
    private final int _numColumns;

    public FixedIntArrayOffHeapIdMap(int estimatedCardinality, int maxOverflowHashSize, int numColumns, PinotDataBufferMemoryManager memoryManager, String allocationContext) {
        super(estimatedCardinality, maxOverflowHashSize, memoryManager, allocationContext);
        int initialSize = this.nearestPowerOf2(estimatedCardinality);
        int[] columnSizesInBytes = new int[numColumns];
        Arrays.fill(columnSizesInBytes, 4);
        this._dictIdToValue = new FixedByteSingleValueMultiColumnReaderWriter(initialSize, columnSizesInBytes, memoryManager, allocationContext);
        this._numColumns = numColumns;
    }

    @Override
    public int put(FixedIntArray key) {
        return this.indexValue(key, null);
    }

    @Override
    public int getId(FixedIntArray key) {
        return this.getDictId(key, null);
    }

    @Override
    public FixedIntArray getKey(int id) {
        int[] value = new int[this._numColumns];
        for (int i = 0; i < this._numColumns; ++i) {
            value[i] = this._dictIdToValue.getInt(id, i);
        }
        return new FixedIntArray(value);
    }

    @Override
    public int size() {
        return this.length();
    }

    @Override
    protected void setValue(int dictId, Object value, byte[] serializedValue) {
        FixedIntArray intArray = (FixedIntArray)value;
        int[] values = intArray.elements();
        for (int i = 0; i < this._numColumns; ++i) {
            this._dictIdToValue.setInt(dictId, i, values[i]);
        }
    }

    @Override
    protected boolean equalsValueAt(int dictId, Object value, byte[] serializedValue) {
        return this.getKey(dictId).equals(value);
    }

    @Override
    public void doClose() throws IOException {
        this._dictIdToValue.close();
    }

    public int index(Object value) {
        throw new UnsupportedOperationException();
    }

    public int[] index(Object[] values) {
        throw new UnsupportedOperationException();
    }

    public int compare(int dictId1, int dictId2) {
        throw new UnsupportedOperationException();
    }

    public IntSet getDictIdsInRange(String lower, String upper, boolean includeLower, boolean includeUpper) {
        throw new UnsupportedOperationException();
    }

    public Comparable getMinVal() {
        throw new UnsupportedOperationException();
    }

    public Comparable getMaxVal() {
        throw new UnsupportedOperationException();
    }

    public Object getSortedValues() {
        throw new UnsupportedOperationException();
    }

    public FieldSpec.DataType getValueType() {
        throw new UnsupportedOperationException();
    }

    public int indexOf(String stringValue) {
        throw new UnsupportedOperationException();
    }

    public Object get(int dictId) {
        throw new UnsupportedOperationException();
    }

    public int getIntValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public long getLongValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public float getFloatValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public double getDoubleValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public String getStringValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getAvgValueSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getTotalOffHeapMemUsed() {
        throw new UnsupportedOperationException();
    }
}

