/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.segment.local.function.FunctionEvaluatorFactory;
import org.apache.pinot.segment.local.utils.TableConfigUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.DateTimeGranularitySpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.TimeFieldSpec;
import org.apache.pinot.spi.data.TimeGranularitySpec;

public class SchemaUtils {
    public static final String MAP_KEY_COLUMN_SUFFIX = "__KEYS";
    public static final String MAP_VALUE_COLUMN_SUFFIX = "__VALUES";

    public static void validate(Schema schema, List<TableConfig> tableConfigs) {
        for (TableConfig tableConfig : tableConfigs) {
            SchemaUtils.validateCompatibilityWithTableConfig(schema, tableConfig);
        }
        SchemaUtils.validate(schema);
    }

    public static void validate(Schema schema) {
        schema.validate();
        HashSet<String> transformedColumns = new HashSet<String>();
        HashSet<String> argumentColumns = new HashSet<String>();
        HashSet<String> primaryKeyColumnCandidates = new HashSet<String>();
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            if (fieldSpec.isVirtualColumn()) continue;
            String column = fieldSpec.getName();
            Preconditions.checkState((!StringUtils.containsWhitespace((CharSequence)column) ? 1 : 0) != 0, (String)"The column name \"%s\" should not contain blank space.", (Object)column);
            primaryKeyColumnCandidates.add(column);
            String transformFunction = fieldSpec.getTransformFunction();
            if (transformFunction != null) {
                try {
                    List<String> arguments = FunctionEvaluatorFactory.getExpressionEvaluator(fieldSpec).getArguments();
                    Preconditions.checkState((!arguments.contains(column) ? 1 : 0) != 0, (String)"The arguments of transform function %s should not contain the destination column %s", (Object)transformFunction, (Object)column);
                    transformedColumns.add(column);
                    argumentColumns.addAll(arguments);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Exception in getting arguments for transform function '" + transformFunction + "' for column '" + column + "'", e);
                }
            }
            if (fieldSpec.getFieldType().equals((Object)FieldSpec.FieldType.TIME)) {
                SchemaUtils.validateTimeFieldSpec(fieldSpec);
            }
            if (!fieldSpec.getFieldType().equals((Object)FieldSpec.FieldType.DATE_TIME)) continue;
            SchemaUtils.validateDateTimeFieldSpec(fieldSpec);
        }
        Preconditions.checkState((boolean)Collections.disjoint(transformedColumns, argumentColumns), (String)"Columns: %s are a result of transformations, and cannot be used as arguments to other transform functions", (Object)transformedColumns.retainAll(argumentColumns));
        if (schema.getPrimaryKeyColumns() != null) {
            for (String primaryKeyColumn : schema.getPrimaryKeyColumns()) {
                Preconditions.checkState((boolean)primaryKeyColumnCandidates.contains(primaryKeyColumn), (Object)"The primary key column must exist");
            }
        }
    }

    private static void validateCompatibilityWithTableConfig(Schema schema, TableConfig tableConfig) {
        try {
            TableConfigUtils.validate(tableConfig, schema);
        }
        catch (Exception e) {
            throw new IllegalStateException("Schema is incompatible with tableConfig with name: " + tableConfig.getTableName() + " and type: " + tableConfig.getTableType(), e);
        }
    }

    private static void validateTimeFieldSpec(FieldSpec fieldSpec) {
        TimeGranularitySpec outgoingGranularitySpec;
        TimeFieldSpec timeFieldSpec = (TimeFieldSpec)fieldSpec;
        TimeGranularitySpec incomingGranularitySpec = timeFieldSpec.getIncomingGranularitySpec();
        if (!incomingGranularitySpec.equals((Object)(outgoingGranularitySpec = timeFieldSpec.getOutgoingGranularitySpec()))) {
            Preconditions.checkState((!incomingGranularitySpec.getName().equals(outgoingGranularitySpec.getName()) ? 1 : 0) != 0, (String)"Cannot convert from incoming field spec %s to outgoing field spec %s if name is the same", (Object)incomingGranularitySpec, (Object)outgoingGranularitySpec);
            Preconditions.checkState((incomingGranularitySpec.getTimeFormat().equals(TimeGranularitySpec.TimeFormat.EPOCH.toString()) && outgoingGranularitySpec.getTimeFormat().equals(TimeGranularitySpec.TimeFormat.EPOCH.toString()) ? 1 : 0) != 0, (String)"Cannot perform time conversion for time format other than EPOCH. TimeFieldSpec: %s", (Object)fieldSpec);
        }
    }

    private static void validateDateTimeFieldSpec(FieldSpec fieldSpec) {
        DateTimeFieldSpec dateTimeFieldSpec = (DateTimeFieldSpec)fieldSpec;
        DateTimeFormatSpec.validateFormat((String)dateTimeFieldSpec.getFormat());
        DateTimeGranularitySpec.validateGranularity((String)dateTimeFieldSpec.getGranularity());
    }
}

