/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.fst;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public class PinotBufferIndexInput
extends IndexInput {
    PinotDataBuffer pinotDataBuffer;
    Long sliceOffset;
    Long readPointerOffset;
    Long length;

    public PinotBufferIndexInput(PinotDataBuffer pinotDataBuffer, Long offset, Long length) {
        super("");
        this.pinotDataBuffer = pinotDataBuffer;
        this.sliceOffset = offset;
        this.readPointerOffset = offset;
        this.length = length;
    }

    public void close() throws IOException {
    }

    public long getFilePointer() {
        return this.readPointerOffset;
    }

    public void seek(long l) throws IOException {
        this.readPointerOffset = this.sliceOffset + l;
    }

    public long length() {
        return this.length;
    }

    public IndexInput slice(String s, long l, long l1) throws IOException {
        return new PinotBufferIndexInput(this.pinotDataBuffer, this.sliceOffset + l, l1);
    }

    public byte readByte() throws IOException {
        Byte b = this.pinotDataBuffer.getByte(this.readPointerOffset.longValue());
        this.readPointerOffset = this.readPointerOffset + 1L;
        return b;
    }

    public void readBytes(byte[] bytes, int destOffset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            bytes[destOffset] = this.readByte();
            ++destOffset;
        }
    }
}

