/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.ExplicitOperatorBinding;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.ComparableOperandTypeChecker;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Static;

public class HiveInOperator
extends SqlSpecialOperator {
    public static final HiveInOperator IN = new HiveInOperator();

    public HiveInOperator() {
        super("IN", SqlKind.OTHER, 32, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, null);
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.any();
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        call.operand(0).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        writer.sep(this.getName());
        SqlWriter.Frame listFrame = writer.startList("(", ")");
        for (int i = 1; i < call.operandCount(); ++i) {
            writer.sep(",");
            call.operand(i).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        }
        writer.endList(listFrame);
    }

    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        RelDataType rightRowType;
        RelDataType leftRowType;
        ComparableOperandTypeChecker checker;
        boolean coerced;
        RelDataType rightType;
        List operands = call.getOperandList();
        assert (operands.size() == 2);
        SqlNode left = (SqlNode)operands.get(0);
        SqlNode right = (SqlNode)operands.get(1);
        RelDataTypeFactory typeFactory = validator.getTypeFactory();
        RelDataType leftType = validator.deriveType(scope, left);
        if (right instanceof SqlNodeList) {
            ArrayList<RelDataType> rightTypeList = new ArrayList<RelDataType>();
            SqlNodeList nodeList = (SqlNodeList)right;
            for (int i = 0; i < nodeList.size(); ++i) {
                SqlNode node = nodeList.get(i);
                RelDataType nodeType = validator.deriveType(scope, node);
                rightTypeList.add(nodeType);
            }
            rightType = typeFactory.leastRestrictive(rightTypeList);
            if (null == rightType && validator.isTypeCoercionEnabled()) {
                rightType = validator.getTypeCoercion().getWiderTypeFor(rightTypeList, true);
            }
            if (null == rightType) {
                throw validator.newValidationError(right, Static.RESOURCE.incompatibleTypesInList());
            }
            ((SqlValidatorImpl)validator).setValidatedNodeType((SqlNode)nodeList, rightType);
        } else {
            rightType = validator.deriveType(scope, right);
        }
        SqlCallBinding callBinding = new SqlCallBinding(validator, scope, call);
        if (callBinding.getValidator().isTypeCoercionEnabled() && (coerced = callBinding.getValidator().getTypeCoercion().inOperationCoercion(callBinding))) {
            leftType = validator.deriveType(scope, call.operand(0));
            rightType = validator.deriveType(scope, call.operand(1));
        }
        if (!(checker = (ComparableOperandTypeChecker)OperandTypes.COMPARABLE_UNORDERED_COMPARABLE_UNORDERED).checkOperandTypes((SqlOperatorBinding)new ExplicitOperatorBinding((SqlOperatorBinding)callBinding, (List)ImmutableList.of((Object)(leftRowType = SqlTypeUtil.promoteToRowType((RelDataTypeFactory)typeFactory, (RelDataType)leftType, null)), (Object)(rightRowType = SqlTypeUtil.promoteToRowType((RelDataTypeFactory)typeFactory, (RelDataType)rightType, null)))), callBinding)) {
            throw validator.newValidationError((SqlNode)call, Static.RESOURCE.incompatibleValueType(SqlStdOperatorTable.IN.getName()));
        }
        return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BOOLEAN), HiveInOperator.anyNullable(leftRowType.getFieldList()) || HiveInOperator.anyNullable(rightRowType.getFieldList()));
    }

    private static boolean anyNullable(List<RelDataTypeField> fieldList) {
        for (RelDataTypeField field : fieldList) {
            if (!field.getType().isNullable()) continue;
            return true;
        }
        return false;
    }
}

