/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import com.google.common.base.Preconditions;
import java.util.AbstractList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;

public class HiveNamedStructFunction
extends SqlUserDefinedFunction {
    public static final HiveNamedStructFunction NAMED_STRUCT = new HiveNamedStructFunction();

    public HiveNamedStructFunction() {
        super(new SqlIdentifier("named_struct", SqlParserPos.ZERO), null, null, null, null, null);
    }

    public RelDataType inferReturnType(final SqlOperatorBinding opBinding) {
        Preconditions.checkState((boolean)(opBinding instanceof SqlCallBinding));
        final SqlCallBinding callBinding = (SqlCallBinding)opBinding;
        return opBinding.getTypeFactory().createStructType((List)new AbstractList<Map.Entry<String, RelDataType>>(){

            @Override
            public int size() {
                return opBinding.getOperandCount() / 2;
            }

            @Override
            public Map.Entry<String, RelDataType> get(int index) {
                String fieldName = callBinding.operand(2 * index).toString();
                String fieldNameNoQuotes = fieldName.substring(1, fieldName.length() - 1);
                return Pair.of((Object)fieldNameNoQuotes, (Object)opBinding.getOperandType(2 * index + 1));
            }
        });
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.any();
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        List operands = callBinding.operands();
        for (int i = 0; i < operands.size() - 1; i += 2) {
            SqlNode fieldName = callBinding.operand(i);
            RelDataType colNameType = callBinding.getValidator().getValidatedNodeType(fieldName);
            if (!SqlUtil.isNull((SqlNode)fieldName) && SqlTypeFamily.STRING.contains(colNameType)) continue;
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.typeNotSupported(colNameType.toString()));
            }
            return false;
        }
        return true;
    }

    protected void checkOperandCount(SqlValidator validator, SqlOperandTypeChecker argTypeChecker, SqlCall call) {
        if (call.operandCount() > 0 && call.operandCount() % 2 == 0) {
            return;
        }
        throw validator.newValidationError((SqlNode)call, Static.RESOURCE.wrongNumOfArguments());
    }
}

