/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.http;

import com.clickhouse.client.ClickHouseInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClickHouseResponseHandler
implements HttpResponse.BodySubscriber<InputStream> {
    private static final List<ByteBuffer> LAST_LIST = List.of(ClickHouseInputStream.EMPTY_BUFFER);
    private final BlockingQueue<ByteBuffer> buffers;
    private final ClickHouseInputStream in;
    private final AtomicBoolean subscribed;

    ClickHouseResponseHandler(int queueLength, int timeout) {
        this.buffers = queueLength > 1 ? new ArrayBlockingQueue(queueLength) : new LinkedBlockingQueue();
        this.in = ClickHouseInputStream.of(this.buffers, timeout);
        this.subscribed = new AtomicBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubscribe(Flow.Subscription s) {
        try {
            if (!this.subscribed.compareAndSet(false, true)) {
                s.cancel();
            } else {
                if (this.in.isClosed()) {
                    s.cancel();
                    return;
                }
                s.request(Long.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.onError(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(List<ByteBuffer> item) {
        try {
            if (!this.buffers.addAll(item)) {
                throw new IllegalStateException("Queue is full");
            }
        }
        catch (Throwable t) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.onError(t);
            }
        }
    }

    @Override
    public void onError(Throwable throwable) {
        this.buffers.offer(ClickHouseInputStream.EMPTY_BUFFER);
    }

    @Override
    public void onComplete() {
        this.onNext(LAST_LIST);
    }

    @Override
    public CompletionStage<InputStream> getBody() {
        return CompletableFuture.completedStage(this.in);
    }
}

