/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal.apache.http.impl.client;

import com.clickhouse.jdbc.internal.apache.http.annotation.Contract;
import com.clickhouse.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import com.clickhouse.jdbc.internal.apache.http.auth.AuthScope;
import com.clickhouse.jdbc.internal.apache.http.auth.Credentials;
import com.clickhouse.jdbc.internal.apache.http.client.CredentialsProvider;
import com.clickhouse.jdbc.internal.apache.http.util.Args;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Contract(threading=ThreadingBehavior.SAFE)
public class BasicCredentialsProvider
implements CredentialsProvider {
    private final ConcurrentHashMap<AuthScope, Credentials> credMap = new ConcurrentHashMap();

    @Override
    public void setCredentials(AuthScope authscope, Credentials credentials) {
        Args.notNull(authscope, "Authentication scope");
        this.credMap.put(authscope, credentials);
    }

    private static Credentials matchCredentials(Map<AuthScope, Credentials> map, AuthScope authscope) {
        Credentials creds = map.get(authscope);
        if (creds == null) {
            int bestMatchFactor = -1;
            AuthScope bestMatch = null;
            for (AuthScope current : map.keySet()) {
                int factor = authscope.match(current);
                if (factor <= bestMatchFactor) continue;
                bestMatchFactor = factor;
                bestMatch = current;
            }
            if (bestMatch != null) {
                creds = map.get(bestMatch);
            }
        }
        return creds;
    }

    @Override
    public Credentials getCredentials(AuthScope authscope) {
        Args.notNull(authscope, "Authentication scope");
        return BasicCredentialsProvider.matchCredentials(this.credMap, authscope);
    }

    @Override
    public void clear() {
        this.credMap.clear();
    }

    public String toString() {
        return this.credMap.toString();
    }
}

