/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.repl;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;

public class DumpDirCleanerTask
implements MetastoreTaskThread {
    public static final Logger LOG = LoggerFactory.getLogger(DumpDirCleanerTask.class);
    private Configuration conf;
    private Path dumpRoot;
    private long ttl;

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.dumpRoot = new Path(HiveConf.getVar(conf, HiveConf.ConfVars.REPLDIR));
        this.ttl = HiveConf.getTimeVar(conf, HiveConf.ConfVars.REPL_DUMPDIR_TTL, TimeUnit.MILLISECONDS);
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public long runFrequency(TimeUnit unit) {
        return HiveConf.getTimeVar(this.conf, HiveConf.ConfVars.REPL_DUMPDIR_CLEAN_FREQ, unit);
    }

    @Override
    public void run() {
        LOG.debug("Trying to delete old dump dirs");
        try {
            FileStatus[] statuses;
            FileSystem fs = FileSystem.get((URI)this.dumpRoot.toUri(), (Configuration)this.conf);
            for (FileStatus status : statuses = fs.listStatus(this.dumpRoot)) {
                if (status.getModificationTime() >= System.currentTimeMillis() - this.ttl) continue;
                fs.delete(status.getPath(), true);
                LOG.info("Deleted old dump dir: " + status.getPath());
            }
        }
        catch (IOException e) {
            LOG.error("Error while trying to delete dump dir", e);
        }
    }
}

