/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import io.trino.hive.$internal.org.apache.commons.logging.Log;
import io.trino.hive.$internal.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IdentityExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public abstract class VectorPTFEvaluatorBase {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorPTFEvaluatorBase.class.getName();
    private static final Log LOG = LogFactory.getLog(CLASS_NAME);
    protected final WindowFrameDef windowFrameDef;
    private final VectorExpression inputVecExpr;
    protected final int inputColumnNum;
    protected final int outputColumnNum;

    public VectorPTFEvaluatorBase(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        this.windowFrameDef = windowFrameDef;
        if (inputVecExpr == null) {
            this.inputColumnNum = -1;
            this.inputVecExpr = null;
        } else {
            this.inputColumnNum = inputVecExpr.getOutputColumnNum();
            this.inputVecExpr = inputVecExpr instanceof IdentityExpression ? null : inputVecExpr;
        }
        this.outputColumnNum = outputColumnNum;
    }

    public void evaluateInputExpr(VectorizedRowBatch batch) throws HiveException {
        if (this.inputVecExpr != null) {
            this.inputVecExpr.evaluate(batch);
        }
    }

    public abstract void evaluateGroupBatch(VectorizedRowBatch var1, boolean var2) throws HiveException;

    public boolean streamsResult() {
        return false;
    }

    public int getOutputColumnNum() {
        return this.outputColumnNum;
    }

    public boolean isGroupResultNull() {
        return false;
    }

    public abstract ColumnVector.Type getResultColumnVectorType();

    public long getLongGroupResult() {
        throw new RuntimeException("No long group result evaluator implementation " + this.getClass().getName());
    }

    public double getDoubleGroupResult() {
        throw new RuntimeException("No double group result evaluator implementation " + this.getClass().getName());
    }

    public HiveDecimalWritable getDecimalGroupResult() {
        throw new RuntimeException("No decimal group result evaluator implementation " + this.getClass().getName());
    }

    public abstract void resetEvaluator();
}

