/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.util.Arrays;
import org.apache.calcite.adapter.jdbc.JdbcRules;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.HiveJdbcConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCRexCallValidator;

public class JDBCJoinPushDownRule
extends RelOptRule {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCJoinPushDownRule.class);
    public static final JDBCJoinPushDownRule INSTANCE = new JDBCJoinPushDownRule();

    public JDBCJoinPushDownRule() {
        super(JDBCJoinPushDownRule.operand(HiveJoin.class, (RelOptRuleOperand)JDBCJoinPushDownRule.operand(HiveJdbcConverter.class, (RelOptRuleOperandChildren)JDBCJoinPushDownRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{JDBCJoinPushDownRule.operand(HiveJdbcConverter.class, (RelOptRuleOperandChildren)JDBCJoinPushDownRule.any())}));
    }

    public boolean matches(RelOptRuleCall call) {
        HiveJoin join = (HiveJoin)call.rel(0);
        RexNode cond = join.getCondition();
        HiveJdbcConverter converter1 = (HiveJdbcConverter)call.rel(1);
        HiveJdbcConverter converter2 = (HiveJdbcConverter)call.rel(2);
        if (!converter1.getJdbcConvention().getName().equals(converter2.getJdbcConvention().getName())) {
            return false;
        }
        if (cond.isAlwaysTrue()) {
            return false;
        }
        boolean visitorRes = JDBCRexCallValidator.isValidJdbcOperation(cond, converter1.getJdbcDialect());
        return visitorRes;
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode converterRes;
        LOG.debug("JDBCJoinPushDownRule has been called");
        HiveJoin join = (HiveJoin)call.rel(0);
        HiveJdbcConverter converter1 = (HiveJdbcConverter)call.rel(1);
        HiveJdbcConverter converter2 = (HiveJdbcConverter)call.rel(2);
        RelNode input1 = converter1.getInput();
        RelNode input2 = converter2.getInput();
        HiveJoin newHiveJoin = join.copy(join.getTraitSet(), join.getCondition(), input1, input2, join.getJoinType(), join.isSemiJoinDone());
        JdbcRules.JdbcJoin newJdbcJoin = (JdbcRules.JdbcJoin)new JdbcRules.JdbcJoinRule(converter1.getJdbcConvention()).convert((Join)newHiveJoin, false);
        if (newJdbcJoin != null && (converterRes = converter1.copy(converter1.getTraitSet(), Arrays.asList(newJdbcJoin))) != null) {
            call.transformTo(converterRes);
        }
    }
}

