/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.writer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.trino.orc.checkpoint.BooleanStreamCheckpoint;
import io.trino.orc.metadata.ColumnEncoding;
import io.trino.orc.metadata.CompressedMetadataWriter;
import io.trino.orc.metadata.CompressionKind;
import io.trino.orc.metadata.OrcColumnId;
import io.trino.orc.metadata.RowGroupIndex;
import io.trino.orc.metadata.Stream;
import io.trino.orc.metadata.statistics.BooleanStatisticsBuilder;
import io.trino.orc.metadata.statistics.ColumnStatistics;
import io.trino.orc.stream.BooleanOutputStream;
import io.trino.orc.stream.PresentOutputStream;
import io.trino.orc.stream.StreamDataOutput;
import io.trino.orc.writer.ColumnWriter;
import io.trino.spi.block.Block;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class BooleanColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BooleanColumnWriter.class).instanceSize();
    private static final ColumnEncoding COLUMN_ENCODING = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0);
    private final OrcColumnId columnId;
    private final Type type;
    private final boolean compressed;
    private final BooleanOutputStream dataStream;
    private final PresentOutputStream presentStream;
    private final List<ColumnStatistics> rowGroupColumnStatistics = new ArrayList<ColumnStatistics>();
    private BooleanStatisticsBuilder statisticsBuilder = new BooleanStatisticsBuilder();
    private boolean closed;

    public BooleanColumnWriter(OrcColumnId columnId, Type type, CompressionKind compression, int bufferSize) {
        this.columnId = Objects.requireNonNull(columnId, "columnId is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.compressed = Objects.requireNonNull(compression, "compression is null") != CompressionKind.NONE;
        this.dataStream = new BooleanOutputStream(compression, bufferSize);
        this.presentStream = new PresentOutputStream(compression, bufferSize);
    }

    @Override
    public Map<OrcColumnId, ColumnEncoding> getColumnEncodings() {
        return ImmutableMap.of((Object)this.columnId, (Object)COLUMN_ENCODING);
    }

    @Override
    public void beginRowGroup() {
        this.presentStream.recordCheckpoint();
        this.dataStream.recordCheckpoint();
    }

    @Override
    public void writeBlock(Block block) {
        int position;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Block is empty");
        for (position = 0; position < block.getPositionCount(); ++position) {
            this.presentStream.writeBoolean(!block.isNull(position));
        }
        for (position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            boolean value = this.type.getBoolean(block, position);
            this.dataStream.writeBoolean(value);
            this.statisticsBuilder.addValue(value);
        }
    }

    @Override
    public Map<OrcColumnId, ColumnStatistics> finishRowGroup() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ColumnStatistics statistics = this.statisticsBuilder.buildColumnStatistics();
        this.rowGroupColumnStatistics.add(statistics);
        this.statisticsBuilder = new BooleanStatisticsBuilder();
        return ImmutableMap.of((Object)this.columnId, (Object)statistics);
    }

    @Override
    public void close() {
        this.closed = true;
        this.dataStream.close();
        this.presentStream.close();
    }

    @Override
    public Map<OrcColumnId, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableMap.of((Object)this.columnId, (Object)ColumnStatistics.mergeColumnStatistics(this.rowGroupColumnStatistics));
    }

    @Override
    public List<StreamDataOutput> getIndexStreams(CompressedMetadataWriter metadataWriter) throws IOException {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder rowGroupIndexes = ImmutableList.builder();
        List<BooleanStreamCheckpoint> dataCheckpoints = this.dataStream.getCheckpoints();
        Optional<List<BooleanStreamCheckpoint>> presentCheckpoints = this.presentStream.getCheckpoints();
        int i = 0;
        while (i < this.rowGroupColumnStatistics.size()) {
            int groupId = i++;
            ColumnStatistics columnStatistics = this.rowGroupColumnStatistics.get(groupId);
            BooleanStreamCheckpoint dataCheckpoint = dataCheckpoints.get(groupId);
            Optional<BooleanStreamCheckpoint> presentCheckpoint = presentCheckpoints.map(checkpoints -> (BooleanStreamCheckpoint)checkpoints.get(groupId));
            List<Integer> positions = BooleanColumnWriter.createBooleanColumnPositionList(this.compressed, dataCheckpoint, presentCheckpoint);
            rowGroupIndexes.add((Object)new RowGroupIndex(positions, columnStatistics));
        }
        Slice slice = metadataWriter.writeRowIndexes((List<RowGroupIndex>)rowGroupIndexes.build());
        Stream stream = new Stream(this.columnId, Stream.StreamKind.ROW_INDEX, slice.length(), false);
        return ImmutableList.of((Object)new StreamDataOutput(slice, stream));
    }

    @Override
    public List<StreamDataOutput> getBloomFilters(CompressedMetadataWriter metadataWriter) {
        return ImmutableList.of();
    }

    private static List<Integer> createBooleanColumnPositionList(boolean compressed, BooleanStreamCheckpoint dataCheckpoint, Optional<BooleanStreamCheckpoint> presentCheckpoint) {
        ImmutableList.Builder positionList = ImmutableList.builder();
        presentCheckpoint.ifPresent(booleanStreamCheckpoint -> positionList.addAll(booleanStreamCheckpoint.toPositionList(compressed)));
        positionList.addAll(dataCheckpoint.toPositionList(compressed));
        return positionList.build();
    }

    @Override
    public List<StreamDataOutput> getDataStreams() {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        this.presentStream.getStreamDataOutput(this.columnId).ifPresent(arg_0 -> ((ImmutableList.Builder)outputDataStreams).add(arg_0));
        outputDataStreams.add((Object)this.dataStream.getStreamDataOutput(this.columnId));
        return outputDataStreams.build();
    }

    @Override
    public long getBufferedBytes() {
        return this.dataStream.getBufferedBytes() + this.presentStream.getBufferedBytes();
    }

    @Override
    public long getRetainedBytes() {
        long retainedBytes = (long)INSTANCE_SIZE + this.dataStream.getRetainedBytes() + this.presentStream.getRetainedBytes();
        for (ColumnStatistics statistics : this.rowGroupColumnStatistics) {
            retainedBytes += statistics.getRetainedSizeInBytes();
        }
        return retainedBytes;
    }

    @Override
    public void reset() {
        this.closed = false;
        this.dataStream.reset();
        this.presentStream.reset();
        this.rowGroupColumnStatistics.clear();
        this.statisticsBuilder = new BooleanStatisticsBuilder();
    }
}

