/*
 * Decompiled with CFR 0.152.
 */
package io.trino.rcfile.binary;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.plugin.base.type.DecodedTimestamp;
import io.trino.plugin.base.type.TrinoTimestampEncoder;
import io.trino.plugin.base.type.TrinoTimestampEncoderFactory;
import io.trino.rcfile.ColumnData;
import io.trino.rcfile.EncodeOutput;
import io.trino.rcfile.RcFileDecoderUtils;
import io.trino.rcfile.TimestampHolder;
import io.trino.rcfile.binary.BinaryColumnEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.TimestampType;
import java.util.Objects;
import java.util.function.BiFunction;
import org.joda.time.DateTimeZone;

public class TimestampEncoding
implements BinaryColumnEncoding {
    private final TimestampType type;
    private final DateTimeZone timeZone;
    private final TrinoTimestampEncoder<?> trinoTimestampEncoder;

    public TimestampEncoding(TimestampType type, DateTimeZone timeZone) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        this.trinoTimestampEncoder = TrinoTimestampEncoderFactory.createTimestampEncoder((TimestampType)this.type, (DateTimeZone)timeZone);
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        BiFunction<Block, Integer, TimestampHolder> factory = TimestampHolder.getFactory(this.type);
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (!block.isNull(position)) {
                this.writeTimestamp(output, factory.apply(block, position));
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(Block block, int position, SliceOutput output) {
        this.writeTimestamp(output, TimestampHolder.getFactory(this.type).apply(block, position));
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int length = columnData.getLength(i);
            if (length != 0) {
                int offset = columnData.getOffset(i);
                DecodedTimestamp decodedTimestamp = this.getTimestamp(slice, offset);
                this.trinoTimestampEncoder.write(decodedTimestamp, builder);
                continue;
            }
            builder.appendNull();
        }
        return builder.build();
    }

    @Override
    public int getValueOffset(Slice slice, int offset) {
        return 0;
    }

    @Override
    public int getValueLength(Slice slice, int offset) {
        int length = 4;
        if (TimestampEncoding.hasNanosVInt(slice.getByte(offset))) {
            int nanosVintLength = RcFileDecoderUtils.decodeVIntSize(slice, offset + 4);
            length += nanosVintLength;
            if (RcFileDecoderUtils.isNegativeVInt(slice, offset + 4)) {
                length += RcFileDecoderUtils.decodeVIntSize(slice, offset + 4 + nanosVintLength);
            }
        }
        return length;
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        DecodedTimestamp decodedTimestamp = this.getTimestamp(slice, offset);
        this.trinoTimestampEncoder.write(decodedTimestamp, builder);
    }

    private static boolean hasNanosVInt(byte b) {
        return b >> 7 != 0;
    }

    private DecodedTimestamp getTimestamp(Slice slice, int offset) {
        int lowest31BitsOfSecondsAndFlag = Integer.reverseBytes(slice.getInt(offset));
        long seconds = lowest31BitsOfSecondsAndFlag & Integer.MAX_VALUE;
        offset += 4;
        int nanos = 0;
        if (lowest31BitsOfSecondsAndFlag < 0) {
            byte nanosFirstByte = slice.getByte(offset);
            int nanosLength = RcFileDecoderUtils.decodeVIntSize(nanosFirstByte);
            nanos = (int)RcFileDecoderUtils.readVInt(slice, offset, nanosLength);
            nanos = TimestampEncoding.decodeNanos(nanos);
            if (RcFileDecoderUtils.isNegativeVInt(nanosFirstByte)) {
                long highBits = RcFileDecoderUtils.readVInt(slice, offset + nanosLength);
                seconds |= highBits << 31;
            }
        }
        return new DecodedTimestamp(seconds, nanos);
    }

    private static int decodeNanos(int nanos) {
        if (nanos < 0) {
            nanos = -nanos - 1;
        }
        int nanosDigits = (int)Math.floor(Math.log10(nanos)) + 1;
        int temp = 0;
        while (nanos != 0) {
            temp *= 10;
            temp += nanos % 10;
            nanos /= 10;
        }
        nanos = temp;
        if (nanosDigits < 9) {
            nanos = (int)((double)nanos * Math.pow(10.0, 9 - nanosDigits));
        }
        return nanos;
    }

    private void writeTimestamp(SliceOutput output, TimestampHolder timestamp) {
        long millis = this.timeZone.convertLocalToUTC(timestamp.getSeconds() * 1000L, false);
        long seconds = millis / 1000L;
        int nanos = timestamp.getNanosOfSecond();
        TimestampEncoding.writeTimestamp(seconds, nanos, output);
    }

    private static void writeTimestamp(long seconds, int nanos, SliceOutput output) {
        boolean hasSecondsHigh32 = seconds < 0L || seconds > Integer.MAX_VALUE;
        int nanosReversed = TimestampEncoding.reverseDecimal(nanos);
        int secondsLow32 = (int)seconds;
        secondsLow32 = nanosReversed == 0 && !hasSecondsHigh32 ? (secondsLow32 &= Integer.MAX_VALUE) : (secondsLow32 |= Integer.MIN_VALUE);
        output.writeInt(Integer.reverseBytes(secondsLow32));
        if (hasSecondsHigh32 || nanosReversed != 0) {
            int value = hasSecondsHigh32 ? ~nanosReversed : nanosReversed;
            RcFileDecoderUtils.writeVInt(output, value);
        }
        if (hasSecondsHigh32) {
            int secondsHigh32 = (int)(seconds >> 31);
            RcFileDecoderUtils.writeVInt(output, secondsHigh32);
        }
    }

    private static int reverseDecimal(int nanos) {
        int decimal = 0;
        if (nanos != 0) {
            for (int counter = 0; counter < 9; ++counter) {
                decimal *= 10;
                decimal += nanos % 10;
                nanos /= 10;
            }
        }
        return decimal;
    }
}

