/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;

public class FieldConfig
extends BaseJsonConfig {
    private final String _name;
    private final EncodingType _encodingType;
    private final IndexType _indexType;
    private final CompressionCodec _compressionCodec;
    private final Map<String, String> _properties;
    public static String BLOOM_FILTER_COLUMN_KEY = "createBloomFilter";
    public static String ON_HEAP_DICTIONARY_COLUMN_KEY = "useOnHeapDictionary";
    public static String VAR_LENGTH_DICTIONARY_COLUMN_KEY = "useVarLengthDictionary";
    public static String DERIVE_NUM_DOCS_PER_CHUNK_RAW_INDEX_KEY = "deriveNumDocsPerChunkForRawIndex";
    public static String RAW_INDEX_WRITER_VERSION = "rawIndexWriterVersion";
    public static String TEXT_INDEX_REALTIME_READER_REFRESH_KEY = "textIndexRealtimeReaderRefreshThreshold";
    public static String TEXT_INDEX_ENABLE_QUERY_CACHE = "enableQueryCacheForTextIndex";
    public static String TEXT_INDEX_USE_AND_FOR_MULTI_TERM_QUERIES = "useANDForMultiTermTextIndexQueries";
    public static String TEXT_INDEX_NO_RAW_DATA = "noRawDataForTextIndex";
    public static String TEXT_INDEX_RAW_VALUE = "rawValueForTextIndex";
    public static String TEXT_INDEX_DEFAULT_RAW_VALUE = "n";

    @JsonCreator
    public FieldConfig(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="encodingType") @Nullable EncodingType encodingType, @JsonProperty(value="indexType") @Nullable IndexType indexType, @JsonProperty(value="compressionCodec") @Nullable CompressionCodec compressionCodec, @JsonProperty(value="properties") @Nullable Map<String, String> properties) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"'name' must be configured");
        this._name = name;
        this._encodingType = encodingType;
        this._indexType = indexType;
        this._compressionCodec = compressionCodec;
        this._properties = properties;
    }

    public String getName() {
        return this._name;
    }

    @Nullable
    public EncodingType getEncodingType() {
        return this._encodingType;
    }

    @Nullable
    public IndexType getIndexType() {
        return this._indexType;
    }

    @Nullable
    public CompressionCodec getCompressionCodec() {
        return this._compressionCodec;
    }

    @Nullable
    public Map<String, String> getProperties() {
        return this._properties;
    }

    public static enum CompressionCodec {
        PASS_THROUGH,
        SNAPPY,
        ZSTANDARD,
        LZ4;

    }

    public static enum IndexType {
        INVERTED,
        SORTED,
        TEXT,
        FST,
        H3;

    }

    public static enum EncodingType {
        RAW,
        DICTIONARY;

    }
}

