/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;
import org.apache.pinot.spi.config.table.ColumnPartitionConfig;

public class SegmentPartitionConfig
extends BaseJsonConfig {
    public static final int INVALID_NUM_PARTITIONS = -1;
    private final Map<String, ColumnPartitionConfig> _columnPartitionMap;

    @JsonCreator
    public SegmentPartitionConfig(@JsonProperty(value="columnPartitionMap", required=true) Map<String, ColumnPartitionConfig> columnPartitionMap) {
        Preconditions.checkArgument((columnPartitionMap != null ? 1 : 0) != 0, (Object)"'columnPartitionMap' must be configured");
        this._columnPartitionMap = columnPartitionMap;
    }

    public Map<String, ColumnPartitionConfig> getColumnPartitionMap() {
        return this._columnPartitionMap;
    }

    @Nullable
    public String getFunctionName(String column) {
        ColumnPartitionConfig columnPartitionConfig = this._columnPartitionMap.get(column);
        return columnPartitionConfig != null ? columnPartitionConfig.getFunctionName() : null;
    }

    public int getNumPartitions(String column) {
        ColumnPartitionConfig config = this._columnPartitionMap.get(column);
        return config != null ? config.getNumPartitions() : -1;
    }
}

