/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;

public class UpsertConfig
extends BaseJsonConfig {
    @JsonPropertyDescription(value="Upsert mode.")
    private final Mode _mode;
    @JsonPropertyDescription(value="Partial update strategies.")
    private final Map<String, Strategy> _partialUpsertStrategies;

    @JsonCreator
    public UpsertConfig(@JsonProperty(value="mode", required=true) Mode mode, @JsonProperty(value="partialUpsertStrategies") @Nullable Map<String, Strategy> partialUpsertStrategies) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"Upsert mode must be configured");
        this._mode = mode;
        this._partialUpsertStrategies = mode == Mode.PARTIAL ? (partialUpsertStrategies != null ? partialUpsertStrategies : new HashMap()) : null;
    }

    public Mode getMode() {
        return this._mode;
    }

    @Nullable
    public Map<String, Strategy> getPartialUpsertStrategies() {
        return this._partialUpsertStrategies;
    }

    public static enum Strategy {
        APPEND,
        INCREMENT,
        OVERWRITE,
        UNION;

    }

    public static enum Mode {
        FULL,
        PARTIAL,
        NONE;

    }
}

