/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.tenant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.pinot.spi.config.BaseJsonConfig;
import org.apache.pinot.spi.config.tenant.TenantRole;

public class Tenant
extends BaseJsonConfig {
    private final TenantRole _tenantRole;
    private final String _tenantName;
    private final int _numberOfInstances;
    private final int _offlineInstances;
    private final int _realtimeInstances;

    @JsonCreator
    public Tenant(@JsonProperty(value="tenantRole", required=true) TenantRole tenantRole, @JsonProperty(value="tenantName", required=true) String tenantName, @JsonProperty(value="numberOfInstances") int numberOfInstances, @JsonProperty(value="offlineInstances") int offlineInstances, @JsonProperty(value="realtimeInstances") int realtimeInstances) {
        Preconditions.checkArgument((tenantRole != null ? 1 : 0) != 0, (Object)"'tenantRole' must be configured");
        Preconditions.checkArgument((tenantName != null ? 1 : 0) != 0, (Object)"'tenantName' must be configured");
        this._tenantRole = tenantRole;
        this._tenantName = tenantName;
        this._numberOfInstances = numberOfInstances;
        this._offlineInstances = offlineInstances;
        this._realtimeInstances = realtimeInstances;
    }

    public TenantRole getTenantRole() {
        return this._tenantRole;
    }

    public String getTenantName() {
        return this._tenantName;
    }

    public int getNumberOfInstances() {
        return this._numberOfInstances;
    }

    public int getOfflineInstances() {
        return this._offlineInstances;
    }

    public int getRealtimeInstances() {
        return this._realtimeInstances;
    }

    @JsonIgnore
    public boolean isCoLocated() {
        return this._realtimeInstances + this._offlineInstances > this._numberOfInstances;
    }
}

