/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.EnumUtils;
import org.apache.pinot.spi.utils.EqualityUtils;

public class DateTimeGranularitySpec {
    public static final String NUMBER_REGEX = "[1-9][0-9]*";
    public static final String COLON_SEPARATOR = ":";
    public static final int GRANULARITY_SIZE_POSITION = 0;
    public static final int GRANULARITY_UNIT_POSITION = 1;
    public static final int MAX_GRANULARITY_TOKENS = 2;
    private final String _granularity;
    private final int _size;
    private final TimeUnit _timeUnit;

    public DateTimeGranularitySpec(String granularity) {
        DateTimeGranularitySpec.validateGranularity(granularity);
        this._granularity = granularity;
        String[] granularityTokens = this._granularity.split(COLON_SEPARATOR);
        this._size = Integer.parseInt(granularityTokens[0]);
        this._timeUnit = TimeUnit.valueOf(granularityTokens[1]);
    }

    public DateTimeGranularitySpec(int columnSize, TimeUnit columnUnit) {
        this._granularity = Joiner.on((String)COLON_SEPARATOR).join((Object)columnSize, (Object)columnUnit, new Object[0]);
        DateTimeGranularitySpec.validateGranularity(this._granularity);
        this._size = columnSize;
        this._timeUnit = columnUnit;
    }

    public String getGranularity() {
        return this._granularity;
    }

    public int getSize() {
        return this._size;
    }

    public TimeUnit getTimeUnit() {
        return this._timeUnit;
    }

    public long granularityToMillis() {
        return TimeUnit.MILLISECONDS.convert(this._size, this._timeUnit);
    }

    public static void validateGranularity(String granularity) {
        Preconditions.checkNotNull((Object)granularity, (Object)"Granularity string in dateTimeFieldSpec must not be null");
        String[] granularityTokens = granularity.split(COLON_SEPARATOR);
        Preconditions.checkState((granularityTokens.length == 2 ? 1 : 0) != 0, (String)"Incorrect granularity: %s. Must be of format 'size:timeunit'", (Object)granularity);
        Preconditions.checkState((boolean)granularityTokens[0].matches(NUMBER_REGEX), (String)"Incorrect granularity size: %s. Must be of format '[0-9]+:<TimeUnit>'", (Object)granularityTokens[0]);
        Preconditions.checkState((boolean)EnumUtils.isValidEnum(TimeUnit.class, (String)granularityTokens[1]), (String)"Incorrect granularity size: %s. Must be of format '[0-9]+:<TimeUnit>'", (Object)granularityTokens[0]);
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        DateTimeGranularitySpec that = (DateTimeGranularitySpec)o;
        return EqualityUtils.isEqual(this._granularity, that._granularity);
    }

    public int hashCode() {
        return EqualityUtils.hashCodeOf(this._granularity);
    }
}

