/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.spi.data.IngestionSchemaValidator;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.plugin.PluginManager;

public class SchemaValidatorFactory {
    private static final Map<String, String> DEFAULT_RECORD_READER_TO_SCHEMA_VALIDATOR_MAP = new HashMap<String, String>();
    private static final String DEFAULT_AVRO_RECORD_READER_CLASS = "org.apache.pinot.plugin.inputformat.avro.AvroRecordReader";
    private static final String DEFAULT_AVRO_SCHEMA_VALIDATOR_CLASS = "org.apache.pinot.plugin.inputformat.avro.AvroIngestionSchemaValidator";

    private SchemaValidatorFactory() {
    }

    public static IngestionSchemaValidator getSchemaValidator(Schema pinotSchema, String recordReaderClassName, String inputFilePath) throws Exception {
        String schemaValidatorClassName = DEFAULT_RECORD_READER_TO_SCHEMA_VALIDATOR_MAP.get(recordReaderClassName);
        if (schemaValidatorClassName == null) {
            return null;
        }
        IngestionSchemaValidator ingestionSchemaValidator = (IngestionSchemaValidator)PluginManager.get().createInstance(schemaValidatorClassName);
        ingestionSchemaValidator.init(pinotSchema, inputFilePath);
        return ingestionSchemaValidator;
    }

    static {
        DEFAULT_RECORD_READER_TO_SCHEMA_VALIDATOR_MAP.put(DEFAULT_AVRO_RECORD_READER_CLASS, DEFAULT_AVRO_SCHEMA_VALIDATOR_CLASS);
    }
}

