/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data.readers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;

public class RecordReaderUtils {
    public static final String GZIP_FILE_EXTENSION = ".gz";

    private RecordReaderUtils() {
    }

    public static BufferedReader getBufferedReader(File dataFile) throws IOException {
        return new BufferedReader(new InputStreamReader(RecordReaderUtils.getInputStream(dataFile), StandardCharsets.UTF_8));
    }

    public static BufferedInputStream getBufferedInputStream(File dataFile) throws IOException {
        return new BufferedInputStream(RecordReaderUtils.getInputStream(dataFile));
    }

    public static InputStream getInputStream(File dataFile) throws IOException {
        if (dataFile.getName().endsWith(GZIP_FILE_EXTENSION)) {
            return new GZIPInputStream(new FileInputStream(dataFile));
        }
        return new FileInputStream(dataFile);
    }
}

