/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.filesystem;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.pinot.spi.annotations.InterfaceAudience;
import org.apache.pinot.spi.annotations.InterfaceStability;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class PinotFS
implements Closeable,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotFS.class);

    public abstract void init(PinotConfiguration var1);

    public abstract boolean mkdir(URI var1) throws IOException;

    public abstract boolean delete(URI var1, boolean var2) throws IOException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean move(URI srcUri, URI dstUri, boolean overwrite) throws IOException {
        if (!this.exists(srcUri)) {
            LOGGER.warn("Source {} does not exist", (Object)srcUri);
            return false;
        }
        if (this.exists(dstUri)) {
            if (overwrite) {
                this.delete(dstUri, true);
                return this.doMove(srcUri, dstUri);
            }
            LOGGER.warn("Cannot move {} to {}. Destination exists and overwrite flag set to false.", (Object)srcUri, (Object)dstUri);
            return false;
        }
        try {
            Path parentPath = Paths.get(dstUri.getPath(), new String[0]).getParent();
            URI parentUri = new URI(dstUri.getScheme(), dstUri.getAuthority(), parentPath.toString(), null, null);
            this.mkdir(parentUri);
            return this.doMove(srcUri, dstUri);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public abstract boolean doMove(URI var1, URI var2) throws IOException;

    public abstract boolean copy(URI var1, URI var2) throws IOException;

    public abstract boolean exists(URI var1) throws IOException;

    public abstract long length(URI var1) throws IOException;

    public abstract String[] listFiles(URI var1, boolean var2) throws IOException;

    public abstract void copyToLocalFile(URI var1, File var2) throws Exception;

    public abstract void copyFromLocalFile(File var1, URI var2) throws Exception;

    public abstract boolean isDirectory(URI var1) throws IOException;

    public abstract long lastModified(URI var1) throws IOException;

    public abstract boolean touch(URI var1) throws IOException;

    public abstract InputStream open(URI var1) throws IOException;

    @Override
    public void close() throws IOException {
    }
}

