/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.stream;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.pinot.spi.stream.PartitionGroupConsumptionStatus;
import org.apache.pinot.spi.stream.PartitionGroupMetadata;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.stream.StreamConsumerFactory;
import org.apache.pinot.spi.stream.StreamConsumerFactoryProvider;
import org.apache.pinot.spi.stream.StreamMetadataProvider;
import org.apache.pinot.spi.stream.TransientConsumerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionGroupMetadataFetcher
implements Callable<Boolean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionGroupMetadataFetcher.class);
    private List<PartitionGroupMetadata> _newPartitionGroupMetadataList;
    private final StreamConfig _streamConfig;
    private final List<PartitionGroupConsumptionStatus> _partitionGroupConsumptionStatusList;
    private final StreamConsumerFactory _streamConsumerFactory;
    private Exception _exception;
    private final String _topicName;

    public PartitionGroupMetadataFetcher(StreamConfig streamConfig, List<PartitionGroupConsumptionStatus> partitionGroupConsumptionStatusList) {
        this._streamConsumerFactory = StreamConsumerFactoryProvider.create(streamConfig);
        this._topicName = streamConfig.getTopicName();
        this._streamConfig = streamConfig;
        this._partitionGroupConsumptionStatusList = partitionGroupConsumptionStatusList;
    }

    public List<PartitionGroupMetadata> getPartitionGroupMetadataList() {
        return this._newPartitionGroupMetadataList;
    }

    public Exception getException() {
        return this._exception;
    }

    @Override
    public Boolean call() throws Exception {
        Boolean bl;
        block10: {
            String clientId = PartitionGroupMetadataFetcher.class.getSimpleName() + "-" + this._topicName;
            StreamMetadataProvider streamMetadataProvider = this._streamConsumerFactory.createStreamMetadataProvider(clientId);
            try {
                this._newPartitionGroupMetadataList = streamMetadataProvider.computePartitionGroupMetadata(clientId, this._streamConfig, this._partitionGroupConsumptionStatusList, 5000);
                if (this._exception != null) {
                    LOGGER.info("Successfully retrieved PartitionGroupMetadata for topic {}", (Object)this._topicName);
                }
                bl = Boolean.TRUE;
                if (streamMetadataProvider == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (streamMetadataProvider != null) {
                        try {
                            streamMetadataProvider.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TransientConsumerException e) {
                    LOGGER.warn("Could not get partition count for topic {}", (Object)this._topicName, (Object)e);
                    this._exception = e;
                    return Boolean.FALSE;
                }
                catch (Exception e) {
                    LOGGER.warn("Could not get partition count for topic {}", (Object)this._topicName, (Object)e);
                    this._exception = e;
                    throw e;
                }
            }
            streamMetadataProvider.close();
        }
        return bl;
    }
}

