/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import io.trino.hadoop.$internal.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.StorageErrorCode;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
final class NativeAzureFileSystemHelper {
    private static final Logger LOG = LoggerFactory.getLogger(NativeAzureFileSystemHelper.class);

    private NativeAzureFileSystemHelper() {
    }

    public static void cleanup(Logger log, Closeable closeable) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (log == null) break block3;
                    log.debug("Exception in closing {}", (Object)closeable, (Object)e);
                }
            }
        }
    }

    public static Throwable checkForAzureStorageException(Exception e) {
        Throwable innerException;
        for (innerException = e.getCause(); innerException != null && !(innerException instanceof StorageException); innerException = innerException.getCause()) {
        }
        return innerException;
    }

    public static boolean isFileNotFoundException(StorageException e) {
        String errorCode = e.getErrorCode();
        return errorCode != null && (errorCode.equals("BlobNotFound") || errorCode.equals("ResourceNotFound") || errorCode.equals("ContainerNotFound") || errorCode.equals(StorageErrorCode.BLOB_NOT_FOUND.toString()) || errorCode.equals(StorageErrorCode.RESOURCE_NOT_FOUND.toString()) || errorCode.equals(StorageErrorCode.CONTAINER_NOT_FOUND.toString()));
    }

    static boolean isBlobAlreadyExistsConflict(StorageException e) {
        return e.getHttpStatusCode() == 409 && "BlobAlreadyExists".equals(e.getErrorCode());
    }

    public static void logAllLiveStackTraces() {
        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
            LOG.debug("Thread " + entry.getKey().getName());
            StackTraceElement[] trace = entry.getValue();
            for (int j = 0; j < trace.length; ++j) {
                LOG.debug("\tat " + trace[j]);
            }
        }
    }

    static void validateReadArgs(byte[] buffer, int offset, int length) throws EOFException {
        Preconditions.checkArgument(length >= 0, "length is negative");
        Preconditions.checkArgument(buffer != null, "Null buffer");
        if (buffer.length - offset < length) {
            throw new IndexOutOfBoundsException("Requested more bytes than destination buffer size: request length=" + length + ", with offset =" + offset + "; buffer capacity =" + (buffer.length - offset));
        }
    }
}

