/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.LengthInputStream;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import org.apache.hadoop.util.LightWeightGSet;

@InterfaceAudience.Private
public abstract class ReplicaInfo
extends Block
implements Replica,
LightWeightGSet.LinkedElement {
    private LightWeightGSet.LinkedElement next;
    private FsVolumeSpi volume;
    private static final FileIoProvider DEFAULT_FILE_IO_PROVIDER = new FileIoProvider(null, null);

    ReplicaInfo(Block block, FsVolumeSpi vol) {
        this(vol, block.getBlockId(), block.getNumBytes(), block.getGenerationStamp());
    }

    ReplicaInfo(FsVolumeSpi vol, long blockId, long len, long genStamp) {
        super(blockId, len, genStamp);
        this.volume = vol;
    }

    ReplicaInfo(ReplicaInfo from) {
        this(from, from.getVolume());
    }

    public FsVolumeSpi getVolume() {
        return this.volume;
    }

    public FileIoProvider getFileIoProvider() {
        return this.volume != null ? this.volume.getFileIoProvider() : DEFAULT_FILE_IO_PROVIDER;
    }

    void setVolume(FsVolumeSpi vol) {
        this.volume = vol;
    }

    @Override
    public String getStorageUuid() {
        return this.volume.getStorageID();
    }

    public long getBytesReserved() {
        return 0L;
    }

    public abstract URI getBlockURI();

    public abstract InputStream getDataInputStream(long var1) throws IOException;

    public abstract OutputStream getDataOutputStream(boolean var1) throws IOException;

    public abstract boolean blockDataExists();

    public abstract boolean deleteBlockData();

    public abstract long getBlockDataLength();

    public abstract URI getMetadataURI();

    public abstract LengthInputStream getMetadataInputStream(long var1) throws IOException;

    public abstract OutputStream getMetadataOutputStream(boolean var1) throws IOException;

    public abstract boolean metadataExists();

    public abstract boolean deleteMetadata();

    public abstract long getMetadataLength();

    public abstract boolean renameMeta(URI var1) throws IOException;

    public abstract boolean renameData(URI var1) throws IOException;

    public abstract void updateWithReplica(StorageLocation var1);

    public abstract boolean getPinning(LocalFileSystem var1) throws IOException;

    public abstract void setPinning(LocalFileSystem var1) throws IOException;

    public abstract void bumpReplicaGS(long var1) throws IOException;

    public abstract ReplicaInfo getOriginalReplica();

    public abstract long getRecoveryID();

    public abstract void setRecoveryID(long var1);

    public abstract boolean breakHardLinksIfNeeded() throws IOException;

    public abstract ReplicaRecoveryInfo createInfo();

    public abstract int compareWith(FsVolumeSpi.ScanInfo var1);

    public abstract void truncateBlock(long var1) throws IOException;

    public abstract void copyMetadata(URI var1) throws IOException;

    public abstract void copyBlockdata(URI var1) throws IOException;

    public long getOriginalBytesReserved() {
        return 0L;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ", " + super.toString() + ", " + (Object)((Object)this.getState()) + "\n  getNumBytes()     = " + this.getNumBytes() + "\n  getBytesOnDisk()  = " + this.getBytesOnDisk() + "\n  getVisibleLength()= " + this.getVisibleLength() + "\n  getVolume()       = " + this.getVolume() + "\n  getBlockURI()     = " + this.getBlockURI();
    }

    @Override
    public boolean isOnTransientStorage() {
        return this.volume.isTransientStorage();
    }

    @Override
    public LightWeightGSet.LinkedElement getNext() {
        return this.next;
    }

    @Override
    public void setNext(LightWeightGSet.LinkedElement next) {
        this.next = next;
    }
}

