/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.planner;

import io.trino.hadoop.$internal.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolume;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.Step;
import org.apache.hadoop.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class MoveStep
implements Step {
    private DiskBalancerVolume sourceVolume;
    private DiskBalancerVolume destinationVolume;
    private double idealStorage;
    private long bytesToMove;
    private String volumeSetID;
    private long maxDiskErrors;
    private long tolerancePercent;
    private long bandwidth;

    public MoveStep(DiskBalancerVolume sourceVolume, double idealStorage, DiskBalancerVolume destinationVolume, long bytesToMove, String volumeSetID) {
        this.destinationVolume = destinationVolume;
        this.idealStorage = idealStorage;
        this.sourceVolume = sourceVolume;
        this.bytesToMove = bytesToMove;
        this.volumeSetID = volumeSetID;
    }

    public MoveStep() {
    }

    @Override
    public long getBytesToMove() {
        return this.bytesToMove;
    }

    @Override
    public DiskBalancerVolume getDestinationVolume() {
        return this.destinationVolume;
    }

    @Override
    public double getIdealStorage() {
        return this.idealStorage;
    }

    @Override
    public DiskBalancerVolume getSourceVolume() {
        return this.sourceVolume;
    }

    @Override
    public String getVolumeSetID() {
        return this.volumeSetID;
    }

    public void setSourceVolume(DiskBalancerVolume sourceVolume) {
        this.sourceVolume = sourceVolume;
    }

    public void setDestinationVolume(DiskBalancerVolume destinationVolume) {
        this.destinationVolume = destinationVolume;
    }

    public void setIdealStorage(double idealStorage) {
        this.idealStorage = idealStorage;
    }

    public void setBytesToMove(long bytesToMove) {
        this.bytesToMove = bytesToMove;
    }

    public void setVolumeSetID(String volumeSetID) {
        this.volumeSetID = volumeSetID;
    }

    public String toString() {
        return String.format("%s\t %s\t %s\t %s%n", this.getSourceVolume().getPath(), this.getDestinationVolume().getPath(), this.getSizeString(this.getBytesToMove()), this.getDestinationVolume().getStorageType());
    }

    @Override
    public String getSizeString(long size) {
        return StringUtils.TraditionalBinaryPrefix.long2String(size, "", 1);
    }

    @Override
    public long getMaxDiskErrors() {
        return this.maxDiskErrors;
    }

    @Override
    public void setMaxDiskErrors(long maxDiskErrors) {
        this.maxDiskErrors = maxDiskErrors;
    }

    @Override
    public long getTolerancePercent() {
        return this.tolerancePercent;
    }

    @Override
    public void setTolerancePercent(long tolerancePercent) {
        this.tolerancePercent = tolerancePercent;
    }

    @Override
    public long getBandwidth() {
        return this.bandwidth;
    }

    @Override
    public void setBandwidth(long bandwidth) {
        this.bandwidth = bandwidth;
    }
}

