/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import io.trino.hadoop.$internal.com.google.common.base.Joiner;
import io.trino.hadoop.$internal.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NNUpgradeUtil;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.server.namenode.ha.RemoteNameNodeInfo;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.tools.DFSHAAdmin;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class BootstrapStandby
implements Tool,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(BootstrapStandby.class);
    private String nsId;
    private String nnId;
    private List<RemoteNameNodeInfo> remoteNNs;
    private Collection<URI> dirsToFormat;
    private List<URI> editUrisToFormat;
    private List<URI> sharedEditsUris;
    private Configuration conf;
    private boolean force = false;
    private boolean interactive = true;
    private boolean skipSharedEditsCheck = false;
    static final int ERR_CODE_FAILED_CONNECT = 2;
    static final int ERR_CODE_INVALID_VERSION = 3;
    static final int ERR_CODE_ALREADY_FORMATTED = 5;
    static final int ERR_CODE_LOGS_UNAVAILABLE = 6;

    @Override
    public int run(String[] args) throws Exception {
        this.parseArgs(args);
        this.parseConfAndFindOtherNN();
        NameNode.checkAllowFormat(this.conf);
        InetSocketAddress myAddr = DFSUtilClient.getNNAddress(this.conf);
        SecurityUtil.login(this.conf, "dfs.namenode.keytab.file", "dfs.namenode.kerberos.principal", myAddr.getHostName());
        return SecurityUtil.doAsLoginUserOrFatal(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                try {
                    return BootstrapStandby.this.doRun();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void parseArgs(String[] args) {
        for (String arg : args) {
            if ("-force".equals(arg)) {
                this.force = true;
                continue;
            }
            if ("-nonInteractive".equals(arg)) {
                this.interactive = false;
                continue;
            }
            if ("-skipSharedEditsCheck".equals(arg)) {
                this.skipSharedEditsCheck = true;
                continue;
            }
            this.printUsage();
            throw new HadoopIllegalArgumentException("Illegal argument: " + arg);
        }
    }

    private void printUsage() {
        System.out.println("Usage: " + this.getClass().getSimpleName() + " [-force] [-nonInteractive] [-skipSharedEditsCheck]\n\t-force: formats if the name directory exists.\n\t-nonInteractive: formats aborts if the name directory exists,\n\tunless -force option is specified.\n\t-skipSharedEditsCheck: skips edits check which ensures that\n\twe have enough edits already in the shared directory to start\n\tup from the last checkpoint on the active.");
    }

    private NamenodeProtocol createNNProtocolProxy(InetSocketAddress otherIpcAddr) throws IOException {
        return NameNodeProxies.createNonHAProxy(this.getConf(), otherIpcAddr, NamenodeProtocol.class, UserGroupInformation.getLoginUser(), true).getProxy();
    }

    private int doRun() throws IOException {
        int download;
        NamenodeProtocol proxy = null;
        StorageInfo nsInfo = null;
        boolean isUpgradeFinalized = false;
        RemoteNameNodeInfo proxyInfo = null;
        for (int i = 0; i < this.remoteNNs.size(); ++i) {
            proxyInfo = this.remoteNNs.get(i);
            InetSocketAddress otherIpcAddress = proxyInfo.getIpcAddress();
            proxy = this.createNNProtocolProxy(otherIpcAddress);
            try {
                nsInfo = proxy.versionRequest();
                isUpgradeFinalized = proxy.isUpgradeFinalized();
                break;
            }
            catch (IOException ioe) {
                LOG.warn("Unable to fetch namespace information from remote NN at " + otherIpcAddress + ": " + ioe.getMessage());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Full exception trace", ioe);
                continue;
            }
        }
        if (nsInfo == null) {
            LOG.error("Unable to fetch namespace information from any remote NN. Possible NameNodes: " + this.remoteNNs);
            return 2;
        }
        if (!this.checkLayoutVersion((NamespaceInfo)nsInfo)) {
            LOG.error("Layout version on remote node (" + nsInfo.getLayoutVersion() + ") does not match this node's layout version (" + HdfsServerConstants.NAMENODE_LAYOUT_VERSION + ")");
            return 3;
        }
        System.out.println("=====================================================\nAbout to bootstrap Standby ID " + this.nnId + " from:\n           Nameservice ID: " + this.nsId + "\n        Other Namenode ID: " + proxyInfo.getNameNodeID() + "\n  Other NN's HTTP address: " + proxyInfo.getHttpAddress() + "\n  Other NN's IPC  address: " + proxyInfo.getIpcAddress() + "\n             Namespace ID: " + nsInfo.getNamespaceID() + "\n            Block pool ID: " + ((NamespaceInfo)nsInfo).getBlockPoolID() + "\n               Cluster ID: " + nsInfo.getClusterID() + "\n           Layout version: " + nsInfo.getLayoutVersion() + "\n       isUpgradeFinalized: " + isUpgradeFinalized + "\n=====================================================");
        NNStorage storage = new NNStorage(this.conf, this.dirsToFormat, this.editUrisToFormat);
        if (!isUpgradeFinalized) {
            LOG.info("The active NameNode is in Upgrade. Prepare the upgrade for the standby NameNode as well.");
            if (!this.doPreUpgrade(storage, (NamespaceInfo)nsInfo)) {
                return 5;
            }
        } else if (!this.format(storage, (NamespaceInfo)nsInfo)) {
            return 5;
        }
        if ((download = this.downloadImage(storage, proxy, proxyInfo)) != 0) {
            return download;
        }
        if (!isUpgradeFinalized) {
            this.doUpgrade(storage);
        }
        return 0;
    }

    private boolean format(NNStorage storage, NamespaceInfo nsInfo) throws IOException {
        if (!Storage.confirmFormat(storage.dirIterable(null), this.force, this.interactive)) {
            storage.close();
            return false;
        }
        storage.format(nsInfo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doPreUpgrade(NNStorage storage, NamespaceInfo nsInfo) throws IOException {
        boolean isFormatted = false;
        HashMap<Storage.StorageDirectory, Storage.StorageState> dataDirStates = new HashMap<Storage.StorageDirectory, Storage.StorageState>();
        try {
            isFormatted = FSImage.recoverStorageDirs(HdfsServerConstants.StartupOption.UPGRADE, storage, dataDirStates);
            if (dataDirStates.values().contains((Object)Storage.StorageState.NOT_FORMATTED)) {
                isFormatted = false;
                System.err.println("The original storage directory is not formatted.");
            }
        }
        catch (InconsistentFSStateException e) {
            LOG.warn("The storage directory is in an inconsistent state", e);
        }
        finally {
            storage.unlockAll();
        }
        if (!isFormatted && !this.format(storage, nsInfo)) {
            return false;
        }
        FSImage.checkUpgrade(storage);
        Iterator<Storage.StorageDirectory> it = storage.dirIterator(false);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            try {
                NNUpgradeUtil.renameCurToTmp(sd);
            }
            catch (IOException e) {
                LOG.error("Failed to move aside pre-upgrade storage in image directory " + sd.getRoot(), e);
                throw e;
            }
        }
        storage.setStorageInfo(nsInfo);
        storage.setBlockPoolID(nsInfo.getBlockPoolID());
        return true;
    }

    private void doUpgrade(NNStorage storage) throws IOException {
        Iterator<Storage.StorageDirectory> it = storage.dirIterator(false);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            NNUpgradeUtil.doUpgrade(sd, storage);
        }
    }

    private int downloadImage(NNStorage storage, NamenodeProtocol proxy, RemoteNameNodeInfo proxyInfo) throws IOException {
        long imageTxId = proxy.getMostRecentCheckpointTxId();
        long curTxId = proxy.getTransactionID();
        try (FSImage image = new FSImage(this.conf);){
            image.getStorage().setStorageInfo(storage);
            image.initEditLog(HdfsServerConstants.StartupOption.REGULAR);
            assert (image.getEditLog().isOpenForRead()) : "Expected edit log to be open for read";
            if (!this.skipSharedEditsCheck && !this.checkLogsAvailableForRead(image, imageTxId, curTxId)) {
                int n = 6;
                return n;
            }
            MD5Hash hash = TransferFsImage.downloadImageToStorage(proxyInfo.getHttpAddress(), imageTxId, storage, true, true);
            image.saveDigestAndRenameCheckpointImage(NNStorage.NameNodeFile.IMAGE, imageTxId, hash);
            storage.writeTransactionIdFileToStorage(imageTxId, NNStorage.NameNodeDirType.IMAGE);
        }
        return 0;
    }

    private boolean checkLogsAvailableForRead(FSImage image, long imageTxId, long curTxIdOnOtherNode) {
        if (imageTxId == curTxIdOnOtherNode) {
            return true;
        }
        long firstTxIdInLogs = imageTxId + 1L;
        assert (curTxIdOnOtherNode >= firstTxIdInLogs) : "first=" + firstTxIdInLogs + " onOtherNode=" + curTxIdOnOtherNode;
        try {
            Collection<EditLogInputStream> streams = image.getEditLog().selectInputStreams(firstTxIdInLogs, curTxIdOnOtherNode, null, true);
            for (EditLogInputStream stream : streams) {
                IOUtils.closeStream(stream);
            }
            return true;
        }
        catch (IOException e) {
            String msg = "Unable to read transaction ids " + firstTxIdInLogs + "-" + curTxIdOnOtherNode + " from the configured shared edits storage " + Joiner.on(",").join(this.sharedEditsUris) + ". Please copy these logs into the shared edits storage or call saveNamespace on the active node.\nError: " + e.getLocalizedMessage();
            LOG.error(msg, e);
            return false;
        }
    }

    private boolean checkLayoutVersion(NamespaceInfo nsInfo) throws IOException {
        return nsInfo.getLayoutVersion() == HdfsServerConstants.NAMENODE_LAYOUT_VERSION;
    }

    private void parseConfAndFindOtherNN() throws IOException {
        Configuration conf = this.getConf();
        this.nsId = DFSUtil.getNamenodeNameServiceId(conf);
        if (!HAUtil.isHAEnabled(conf, this.nsId)) {
            throw new HadoopIllegalArgumentException("HA is not enabled for this namenode.");
        }
        this.nnId = HAUtil.getNameNodeId(conf, this.nsId);
        NameNode.initializeGenericKeys(conf, this.nsId, this.nnId);
        if (!HAUtil.usesSharedEditsDir(conf)) {
            throw new HadoopIllegalArgumentException("Shared edits storage is not enabled for this namenode.");
        }
        this.remoteNNs = RemoteNameNodeInfo.getRemoteNameNodes(conf, this.nsId);
        ArrayList<RemoteNameNodeInfo> remove = new ArrayList<RemoteNameNodeInfo>(this.remoteNNs.size());
        for (RemoteNameNodeInfo info : this.remoteNNs) {
            InetSocketAddress address = info.getIpcAddress();
            LOG.info("Found nn: " + info.getNameNodeID() + ", ipc: " + info.getIpcAddress());
            if (address.getPort() != 0 && !address.getAddress().isAnyLocalAddress()) continue;
            LOG.error("Could not determine valid IPC address for other NameNode (" + info.getNameNodeID() + ") , got: " + address);
            remove.add(info);
        }
        this.remoteNNs.removeAll(remove);
        Preconditions.checkArgument(!this.remoteNNs.isEmpty(), "Could not find any valid namenodes!");
        this.dirsToFormat = FSNamesystem.getNamespaceDirs(conf);
        this.editUrisToFormat = FSNamesystem.getNamespaceEditsDirs(conf, false);
        this.sharedEditsUris = FSNamesystem.getSharedEditsDirs(conf);
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = DFSHAAdmin.addSecurityConfiguration(conf);
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    public static int run(String[] argv, Configuration conf) throws IOException {
        BootstrapStandby bs = new BootstrapStandby();
        bs.setConf(conf);
        try {
            return ToolRunner.run(bs, argv);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }
}

