/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.snappy;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.util.NativeCodeLoader;

public class SnappyCompressor
implements Compressor {
    private static final Logger LOG = LoggerFactory.getLogger(SnappyCompressor.class.getName());
    private static final int DEFAULT_DIRECT_BUFFER_SIZE = 65536;
    private int directBufferSize;
    private Buffer compressedDirectBuf = null;
    private int uncompressedDirectBufLen;
    private Buffer uncompressedDirectBuf = null;
    private byte[] userBuf = null;
    private int userBufOff = 0;
    private int userBufLen = 0;
    private boolean finish;
    private boolean finished;
    private long bytesRead = 0L;
    private long bytesWritten = 0L;
    private static boolean nativeSnappyLoaded = false;

    public static boolean isNativeCodeLoaded() {
        return nativeSnappyLoaded;
    }

    public SnappyCompressor(int directBufferSize) {
        this.directBufferSize = directBufferSize;
        this.uncompressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.compressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.compressedDirectBuf.position(directBufferSize);
    }

    public SnappyCompressor() {
        this(65536);
    }

    @Override
    public void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.finished = false;
        if (len > this.uncompressedDirectBuf.remaining()) {
            this.userBuf = b;
            this.userBufOff = off;
            this.userBufLen = len;
        } else {
            ((ByteBuffer)this.uncompressedDirectBuf).put(b, off, len);
            this.uncompressedDirectBufLen = this.uncompressedDirectBuf.position();
        }
        this.bytesRead += (long)len;
    }

    void setInputFromSavedData() {
        if (0 >= this.userBufLen) {
            return;
        }
        this.finished = false;
        this.uncompressedDirectBufLen = Math.min(this.userBufLen, this.directBufferSize);
        ((ByteBuffer)this.uncompressedDirectBuf).put(this.userBuf, this.userBufOff, this.uncompressedDirectBufLen);
        this.userBufOff += this.uncompressedDirectBufLen;
        this.userBufLen -= this.uncompressedDirectBufLen;
    }

    @Override
    public void setDictionary(byte[] b, int off, int len) {
    }

    @Override
    public boolean needsInput() {
        return this.compressedDirectBuf.remaining() <= 0 && this.uncompressedDirectBuf.remaining() != 0 && this.userBufLen <= 0;
    }

    @Override
    public void finish() {
        this.finish = true;
    }

    @Override
    public boolean finished() {
        return this.finish && this.finished && this.compressedDirectBuf.remaining() == 0;
    }

    @Override
    public int compress(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = this.compressedDirectBuf.remaining();
        if (n > 0) {
            n = Math.min(n, len);
            ((ByteBuffer)this.compressedDirectBuf).get(b, off, n);
            this.bytesWritten += (long)n;
            return n;
        }
        this.compressedDirectBuf.clear();
        this.compressedDirectBuf.limit(0);
        if (0 == this.uncompressedDirectBuf.position()) {
            this.setInputFromSavedData();
            if (0 == this.uncompressedDirectBuf.position()) {
                this.finished = true;
                return 0;
            }
        }
        n = this.compressBytesDirect();
        this.compressedDirectBuf.limit(n);
        this.uncompressedDirectBuf.clear();
        if (0 == this.userBufLen) {
            this.finished = true;
        }
        n = Math.min(n, len);
        this.bytesWritten += (long)n;
        ((ByteBuffer)this.compressedDirectBuf).get(b, off, n);
        return n;
    }

    @Override
    public void reset() {
        this.finish = false;
        this.finished = false;
        this.uncompressedDirectBuf.clear();
        this.uncompressedDirectBufLen = 0;
        this.compressedDirectBuf.clear();
        this.compressedDirectBuf.limit(0);
        this.userBufLen = 0;
        this.userBufOff = 0;
        this.bytesWritten = 0L;
        this.bytesRead = 0L;
    }

    @Override
    public void reinit(Configuration conf) {
        this.reset();
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public void end() {
    }

    private static native void initIDs();

    private native int compressBytesDirect();

    public static native String getLibraryName();

    static {
        if (NativeCodeLoader.isNativeCodeLoaded() && NativeCodeLoader.buildSupportsSnappy()) {
            try {
                SnappyCompressor.initIDs();
                nativeSnappyLoaded = true;
            }
            catch (Throwable t) {
                LOG.error("failed to load SnappyCompressor", t);
            }
        }
    }
}

