/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import io.trino.hadoop.$internal.com.google.common.base.Charsets;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.authentication.util.SignerSecretProvider;

@InterfaceStability.Unstable
@InterfaceAudience.Private
public class FileSignerSecretProvider
extends SignerSecretProvider {
    private byte[] secret;
    private byte[][] secrets;

    @Override
    public void init(Properties config, ServletContext servletContext, long tokenValidity) throws Exception {
        String signatureSecretFile = config.getProperty("signature.secret.file", null);
        Reader reader = null;
        if (signatureSecretFile != null) {
            try {
                StringBuilder sb = new StringBuilder();
                reader = new InputStreamReader((InputStream)new FileInputStream(signatureSecretFile), Charsets.UTF_8);
                int c = reader.read();
                while (c > -1) {
                    sb.append((char)c);
                    c = reader.read();
                }
                this.secret = sb.toString().getBytes(Charset.forName("UTF-8"));
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not read signature secret file: " + signatureSecretFile);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.secrets = new byte[][]{this.secret};
    }

    @Override
    public byte[] getCurrentSecret() {
        return this.secret;
    }

    @Override
    public byte[][] getAllSecrets() {
        return this.secrets;
    }
}

