/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument.internal;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.BeanPropertyArguments;
import org.jdbi.v3.core.argument.ObjectFieldArguments;
import org.jdbi.v3.core.argument.ObjectMethodArguments;
import org.jdbi.v3.core.argument.internal.PojoPropertyArguments;
import org.jdbi.v3.core.argument.internal.TypedValue;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.mapper.reflect.internal.PojoProperties;
import org.jdbi.v3.core.qualifier.QualifiedType;

public interface NamedArgumentFinderFactory<T> {
    public static final NamedArgumentFinderFactory<Object> BEAN = new Bean<Object>();
    public static final NamedArgumentFinderFactory<Object> POJO = new Pojo<Object>();
    public static final NamedArgumentFinderFactory<Object> FIELDS = new Fields<Object>();
    public static final NamedArgumentFinderFactory<Object> METHODS = new Methods<Object>();

    public PrepareKey keyFor(String var1, Object var2);

    public Function<String, Optional<Function<Object, Argument>>> prepareFor(ConfigRegistry var1, Function<QualifiedType<?>, Function<Object, Argument>> var2, String var3, Object var4, Type var5);

    public static class Bean<T>
    extends Pojo<T> {
        @Override
        public Function<String, Optional<Function<Object, Argument>>> prepareFor(ConfigRegistry config, Function<QualifiedType<?>, Function<Object, Argument>> argumentFactoryLookup, String prefix, Object example, Type type) {
            return this.forPojoProps(argumentFactoryLookup, new BeanPropertyArguments(prefix, example, config));
        }
    }

    public static class Pojo<T>
    extends Base<T, PojoProperties<T>> {
        @Override
        public Function<String, Optional<Function<Object, Argument>>> prepareFor(ConfigRegistry config, Function<QualifiedType<?>, Function<Object, Argument>> argumentFactoryLookup, String prefix, Object example, Type type) {
            return this.forPojoProps(argumentFactoryLookup, new PojoPropertyArguments(prefix, example, type, config));
        }

        Function<String, Optional<Function<Object, Argument>>> forPojoProps(Function<QualifiedType<?>, Function<Object, Argument>> argumentFactoryLookup, PojoPropertyArguments ppa) {
            return name -> Optional.ofNullable(ppa.properties.getProperties().get(name)).map(PojoProperties.PojoProperty.class::cast).map(property -> {
                Function arg = (Function)argumentFactoryLookup.apply(property.getQualifiedType());
                return pojo -> (Argument)arg.apply(property.get(pojo));
            });
        }
    }

    public static class Fields<T>
    extends ReflectionBase<T> {
        @Override
        BiFunction<String, Object, BiFunction<String, ConfigRegistry, Optional<Function<Object, TypedValue>>>> create() {
            return (prefix, example) -> new ObjectFieldArguments((String)prefix, example)::getter;
        }
    }

    public static class Methods<T>
    extends ReflectionBase<T> {
        @Override
        BiFunction<String, Object, BiFunction<String, ConfigRegistry, Optional<Function<Object, TypedValue>>>> create() {
            return (prefix, example) -> new ObjectMethodArguments((String)prefix, example)::getter;
        }
    }

    public static class PrepareKey {
        final Class<?> factoryClass;
        final Type type;
        final String prefix;

        PrepareKey(Class<?> factoryClass, Type type, String prefix) {
            this.factoryClass = factoryClass;
            this.type = type;
            this.prefix = prefix;
        }

        public int hashCode() {
            return Objects.hash(this.factoryClass, this.prefix, this.type);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrepareKey other = (PrepareKey)obj;
            return Objects.equals(this.factoryClass, other.factoryClass) && Objects.equals(this.prefix, other.prefix) && Objects.equals(this.type, other.type);
        }
    }

    public static abstract class ReflectionBase<T>
    extends Base<T, PojoProperties<T>> {
        @Override
        public Function<String, Optional<Function<Object, Argument>>> prepareFor(ConfigRegistry config, Function<QualifiedType<?>, Function<Object, Argument>> argumentFactoryLookup, String prefix, Object example, Type type) {
            return name -> this.create().apply(prefix, example).apply((String)name, config).map(getter -> {
                Function arg = (Function)argumentFactoryLookup.apply(((TypedValue)getter.apply(example)).getType());
                return obj -> (Argument)arg.apply(((TypedValue)getter.apply(obj)).getValue());
            });
        }

        abstract BiFunction<String, Object, BiFunction<String, ConfigRegistry, Optional<Function<Object, TypedValue>>>> create();
    }

    public static abstract class Base<T, PrepareData>
    implements NamedArgumentFinderFactory<T> {
        @Override
        public PrepareKey keyFor(String prefix, Object value) {
            return new PrepareKey(this.getClass(), value.getClass(), prefix);
        }
    }
}

