/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.client.guice;

import io.airlift.drift.client.guice.DefaultClient;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Qualifier;

public final class DriftClientAnnotationFactory {
    private DriftClientAnnotationFactory() {
    }

    public static Annotation getDriftClientAnnotation(Class<?> value, Class<? extends Annotation> qualifier) {
        return new DriftClientAnnotationImpl(value, qualifier);
    }

    public static Optional<Class<? extends Annotation>> extractDriftClientBindingAnnotation(Annotation driftClientAnnotation) {
        DriftClientAnnotation annotation;
        Class<? extends Annotation> qualifier;
        if (driftClientAnnotation instanceof DriftClientAnnotation && (qualifier = (annotation = (DriftClientAnnotation)driftClientAnnotation).qualifier()) != DefaultClient.class) {
            return Optional.of(qualifier);
        }
        return Optional.empty();
    }

    private static final class DriftClientAnnotationImpl
    implements DriftClientAnnotation {
        private final Class<?> value;
        private final Class<? extends Annotation> qualifier;

        private DriftClientAnnotationImpl(Class<?> value, Class<? extends Annotation> qualifier) {
            this.value = Objects.requireNonNull(value, "value is null");
            this.qualifier = Objects.requireNonNull(qualifier, "qualifier is null");
        }

        @Override
        public Class<?> value() {
            return this.value;
        }

        @Override
        public Class<? extends Annotation> qualifier() {
            return this.qualifier;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return DriftClientAnnotation.class;
        }

        @Override
        public int hashCode() {
            return 127 * "value".hashCode() ^ this.value.hashCode() + 127 * "qualifier".hashCode() ^ this.qualifier.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof DriftClientAnnotation)) {
                return false;
            }
            DriftClientAnnotation other = (DriftClientAnnotation)o;
            return Objects.equals(this.value, other.value()) && Objects.equals(this.qualifier, other.qualifier());
        }

        @Override
        public String toString() {
            return String.format("@%s(value=%s, qualifier=%s)", DriftClientAnnotation.class.getName(), this.value, this.qualifier);
        }
    }

    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface DriftClientAnnotation {
        public Class<?> value();

        public Class<? extends Annotation> qualifier();
    }
}

