/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix5;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.io.ByteStreams;
import io.airlift.slice.SizeOf;
import java.io.DataInput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.mapreduce.PhoenixInputSplit;
import org.openjdk.jol.info.ClassLayout;

public class SerializedPhoenixInputSplit {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SerializedPhoenixInputSplit.class).instanceSize();
    private final byte[] bytes;

    public static SerializedPhoenixInputSplit serialize(PhoenixInputSplit split) {
        return new SerializedPhoenixInputSplit(WritableUtils.toByteArray((Writable[])new Writable[]{split}));
    }

    @JsonCreator
    public SerializedPhoenixInputSplit(@JsonProperty(value="bytes") byte[] bytes) {
        this.bytes = Objects.requireNonNull(bytes, "bytes is null");
    }

    @JsonProperty
    public byte[] getBytes() {
        return this.bytes;
    }

    public PhoenixInputSplit deserialize() {
        PhoenixInputSplit split = new PhoenixInputSplit();
        try {
            split.readFields((DataInput)ByteStreams.newDataInput((byte[])this.bytes));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return split;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.bytes);
    }
}

