/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.prometheus;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.trino.plugin.prometheus.PrometheusColumn;
import io.trino.plugin.prometheus.PrometheusConnectorConfig;
import io.trino.plugin.prometheus.PrometheusErrorCode;
import io.trino.plugin.prometheus.PrometheusTable;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.inject.Inject;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class PrometheusClient {
    static final Type TIMESTAMP_COLUMN_TYPE = TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3);
    static final String METRICS_ENDPOINT = "/api/v1/label/__name__/values";
    private final OkHttpClient httpClient;
    private final Optional<File> bearerTokenFile;
    private final Supplier<Map<String, Object>> tableSupplier;
    private final Type varcharMapType;

    @Inject
    public PrometheusClient(PrometheusConnectorConfig config, JsonCodec<Map<String, Object>> metricCodec, TypeManager typeManager) {
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(metricCodec, "metricCodec is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.httpClient = new OkHttpClient.Builder().readTimeout(Duration.ofMillis(config.getReadTimeout().toMillis())).build();
        this.bearerTokenFile = config.getBearerTokenFile();
        URI prometheusMetricsUri = PrometheusClient.getPrometheusMetricsURI(config.getPrometheusURI());
        this.tableSupplier = Suppliers.memoizeWithExpiration(() -> this.fetchMetrics(metricCodec, prometheusMetricsUri), (long)config.getCacheDuration().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        this.varcharMapType = typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
    }

    private static URI getPrometheusMetricsURI(URI prometheusUri) {
        try {
            return new URI(prometheusUri.getScheme(), prometheusUri.getAuthority(), prometheusUri.getPath() + METRICS_ENDPOINT, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> getTableNames(String schema) {
        Objects.requireNonNull(schema, "schema is null");
        String status = "";
        if (schema.equals("default") && (status = (String)this.tableSupplier.get().get("status")).equals("success")) {
            List tableNames = (List)this.tableSupplier.get().get("data");
            if (tableNames == null) {
                return ImmutableSet.of();
            }
            return ImmutableSet.copyOf((Collection)tableNames);
        }
        throw new TrinoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_TABLES_METRICS_RETRIEVE_ERROR, "Prometheus did no return metrics list (table names): " + status);
    }

    public PrometheusTable getTable(String schema, String tableName) {
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(tableName, "tableName is null");
        if (!schema.equals("default")) {
            return null;
        }
        List tableNames = (List)this.tableSupplier.get().get("data");
        if (tableNames == null) {
            return null;
        }
        if (!tableNames.contains(tableName)) {
            return null;
        }
        return new PrometheusTable(tableName, (List<PrometheusColumn>)ImmutableList.of((Object)new PrometheusColumn("labels", this.varcharMapType), (Object)new PrometheusColumn("timestamp", TIMESTAMP_COLUMN_TYPE), (Object)new PrometheusColumn("value", (Type)DoubleType.DOUBLE)));
    }

    private Map<String, Object> fetchMetrics(JsonCodec<Map<String, Object>> metricsCodec, URI metadataUri) {
        return (Map)metricsCodec.fromJson(this.fetchUri(metadataUri));
    }

    public byte[] fetchUri(URI uri) {
        Response response;
        Request.Builder requestBuilder = new Request.Builder().url(uri.toString());
        this.getBearerAuthInfoFromFile().ifPresent(bearerToken -> requestBuilder.header("Authorization", "Bearer " + bearerToken));
        try {
            response = this.httpClient.newCall(requestBuilder.build()).execute();
            if (response.isSuccessful() && response.body() != null) {
                return response.body().bytes();
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_UNKNOWN_ERROR, "Error reading metrics", (Throwable)e);
        }
        throw new TrinoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_UNKNOWN_ERROR, "Bad response " + response.code() + response.message());
    }

    private Optional<String> getBearerAuthInfoFromFile() {
        return this.bearerTokenFile.map(tokenFileName -> {
            try {
                return Files.readString(tokenFileName.toPath(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_UNKNOWN_ERROR, "Failed to read bearer token file: " + tokenFileName, (Throwable)e);
            }
        });
    }
}

