/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.prometheus;

import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.log.Logger;
import io.trino.plugin.prometheus.PrometheusMetadata;
import io.trino.plugin.prometheus.PrometheusRecordSetProvider;
import io.trino.plugin.prometheus.PrometheusSplitManager;
import io.trino.plugin.prometheus.PrometheusTransactionHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Objects;
import javax.inject.Inject;

public class PrometheusConnector
implements Connector {
    private static final Logger log = Logger.get(PrometheusConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final PrometheusMetadata metadata;
    private final PrometheusSplitManager splitManager;
    private final PrometheusRecordSetProvider recordSetProvider;

    @Inject
    public PrometheusConnector(LifeCycleManager lifeCycleManager, PrometheusMetadata metadata, PrometheusSplitManager splitManager, PrometheusRecordSetProvider recordSetProvider) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        return PrometheusTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.recordSetProvider;
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

